/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.crdt;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.CrdtSubscriber;
import io.reactivex.processors.PublishProcessor;
import java.util.Objects;
import javaslang.Function4;
import javaslang.collection.HashMap;
import javaslang.collection.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class GCounter
implements Crdt {
    private final String nodeId;
    private final String id;
    private final Processor<CrdtCommand, CrdtCommand> commands = PublishProcessor.create();
    private Map<String, Long> entries = HashMap.empty();

    public GCounter(String nodeId, String id, Publisher<? extends CrdtCommand> inCommands, Subscriber<? super CrdtCommand> outCommands) {
        this.nodeId = Objects.requireNonNull(nodeId, "NodeId must not be null");
        this.id = Objects.requireNonNull(id, "Id must not be null");
        inCommands = Objects.requireNonNull(inCommands, "InCommands must not be null");
        outCommands = Objects.requireNonNull(outCommands, "OutCommands must not be null");
        inCommands.subscribe((Subscriber)new CrdtSubscriber(this::processCommand));
        this.commands.subscribe(outCommands);
    }

    @Override
    public Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> getFactory() {
        return GCounter::new;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private void processCommand(CrdtCommand command) {
        if (UpdateCommand.class.equals(command.getClass())) {
            UpdateCommand updateCommand = (UpdateCommand)command;
            this.entries = this.entries.merge(updateCommand.entries, Math::max);
        }
    }

    public long get() {
        return this.entries.values().sum().longValue();
    }

    public void increment() {
        this.increment(1L);
    }

    public void increment(long value) {
        if (value < 1L) {
            throw new IllegalArgumentException("Value needs to be a positive number.");
        }
        this.entries = this.entries.put((Object)this.nodeId, (Object)((Long)this.entries.get((Object)this.nodeId).getOrElse((Object)0L) + value));
        this.commands.onNext((Object)new UpdateCommand(this.id, this.entries));
    }

    static final class UpdateCommand
    extends CrdtCommand {
        private final Map<String, Long> entries;

        private UpdateCommand(String crdtId, Map<String, Long> entries) {
            super(crdtId);
            this.entries = Objects.requireNonNull(entries, "Entries must not be null");
        }

        Map<String, Long> getEntries() {
            return this.entries;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateCommand that = (UpdateCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.entries, that.entries).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.entries).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("entries", this.entries).toString();
        }
    }
}

