/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.crdt;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.CrdtSubscriber;
import com.netopyr.wurmloch.vectorclock.StrictVectorClock;
import io.reactivex.processors.PublishProcessor;
import java.util.Objects;
import javaslang.Function4;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class LWWRegister<T>
implements Crdt {
    private final String id;
    private final Processor<CrdtCommand, CrdtCommand> commands = PublishProcessor.create();
    private T value;
    private StrictVectorClock clock;

    public LWWRegister(String nodeId, String id, Publisher<? extends CrdtCommand> inCommands, Subscriber<? super CrdtCommand> outCommands) {
        this.id = Objects.requireNonNull(id, "Id must not be null");
        Objects.requireNonNull(nodeId, "NodeId must not be null");
        this.clock = new StrictVectorClock(nodeId);
        inCommands = Objects.requireNonNull(inCommands, "InCommands must not be null");
        outCommands = Objects.requireNonNull(outCommands, "OutCommands must not be null");
        inCommands.subscribe((Subscriber)new CrdtSubscriber(this::processCommand));
        this.commands.subscribe(outCommands);
    }

    @Override
    public Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> getFactory() {
        return LWWRegister::new;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public T get() {
        return this.value;
    }

    public void set(T newValue) {
        if (!Objects.equals(this.value, newValue)) {
            this.doSet(newValue);
            this.commands.onNext(new SetCommand<T>(this.id, this.value, this.clock));
        }
    }

    private void processCommand(CrdtCommand command) {
        SetCommand setCommand;
        Class<?> clazz = command.getClass();
        if (SetCommand.class.equals(clazz) && this.clock.compareTo((setCommand = (SetCommand)command).getClock()) < 0) {
            this.clock = this.clock.merge(setCommand.getClock());
            this.doSet(setCommand.getValue());
        }
    }

    private void doSet(T value) {
        this.value = value;
        this.clock = this.clock.increment();
    }

    static final class SetCommand<T>
    extends CrdtCommand {
        private final T value;
        private final StrictVectorClock clock;

        SetCommand(String crdtId, T value, StrictVectorClock clock) {
            super(crdtId);
            this.value = value;
            this.clock = Objects.requireNonNull(clock, "Clock must not be null");
        }

        T getValue() {
            return this.value;
        }

        StrictVectorClock getClock() {
            return this.clock;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetCommand that = (SetCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.value, that.value).append((Object)this.clock, (Object)that.clock).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.value).append((Object)this.clock).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("value", this.value).append("clock", (Object)this.clock).toString();
        }
    }
}

