/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.crdt;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.CrdtSubscriber;
import com.netopyr.wurmloch.vectorclock.VectorClock;
import io.reactivex.processors.PublishProcessor;
import java.util.Objects;
import javaslang.Function4;
import javaslang.collection.Array;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MVRegister<T>
implements Crdt {
    private final String nodeId;
    private final String id;
    private final Processor<CrdtCommand, CrdtCommand> commands = PublishProcessor.create();
    private Array<Entry<T>> entries = Array.empty();

    public MVRegister(String nodeId, String id, Publisher<? extends CrdtCommand> inCommands, Subscriber<? super CrdtCommand> outCommands) {
        this.nodeId = Objects.requireNonNull(nodeId, "NodeId must not be null");
        this.id = Objects.requireNonNull(id, "Id must not be null");
        inCommands = Objects.requireNonNull(inCommands, "InCommands must not be null");
        outCommands = Objects.requireNonNull(outCommands, "OutCommands must not be null");
        inCommands.subscribe((Subscriber)new CrdtSubscriber(this::processCommand));
        this.commands.subscribe(outCommands);
    }

    @Override
    public Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> getFactory() {
        return MVRegister::new;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Array<T> get() {
        return this.entries.map(Entry::getValue);
    }

    public void set(T newValue) {
        if (this.entries.size() != 1 || !Objects.equals(((Entry)this.entries.head()).getValue(), newValue)) {
            Entry newEntry = new Entry(newValue, this.incVV());
            this.doSet(Array.of(newEntry));
            this.commands.onNext(new SetCommand(this.id, newEntry));
        }
    }

    private void doSet(Array<Entry<T>> newEntries) {
        this.entries = newEntries;
    }

    private VectorClock incVV() {
        Array clocks = this.entries.map(Entry::getClock);
        VectorClock mergedClock = (VectorClock)clocks.reduceOption(VectorClock::merge).getOrElse((Object)new VectorClock());
        return mergedClock.increment(this.nodeId);
    }

    private void processCommand(CrdtCommand command) {
        if (command instanceof SetCommand) {
            Entry newEntry = ((SetCommand)command).getEntry();
            if (this.entries.exists(entry -> entry.getClock().compareTo(newEntry.getClock()) > 0)) {
                return;
            }
            Array newEntries = this.entries.filter(entry -> entry.getClock().compareTo(newEntry.getClock()) == 0).filter(entry -> !entry.getClock().equals(newEntry.getClock())).append(newEntry);
            this.doSet(newEntries);
        }
    }

    static final class SetCommand<T>
    extends CrdtCommand {
        private final Entry<T> entry;

        SetCommand(String crdtId, Entry<T> entry) {
            super(crdtId);
            this.entry = Objects.requireNonNull(entry, "Entry must not be null");
        }

        Entry<T> getEntry() {
            return this.entry;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetCommand that = (SetCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.entry, that.entry).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.entry).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("entry", this.entry).toString();
        }
    }

    static final class Entry<T> {
        private final T value;
        private final VectorClock clock;

        private Entry(T value, VectorClock clock) {
            this.value = value;
            this.clock = Objects.requireNonNull(clock, "Clock must not be null");
        }

        T getValue() {
            return this.value;
        }

        VectorClock getClock() {
            return this.clock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return new EqualsBuilder().append(this.value, entry.value).append((Object)this.clock, (Object)entry.clock).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.value).append((Object)this.clock).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("value", this.value).append("clock", (Object)this.clock).toString();
        }
    }
}

