/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.crdt;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.CrdtSubscriber;
import com.netopyr.wurmloch.vectorclock.StrictVectorClock;
import io.reactivex.processors.PublishProcessor;
import java.util.AbstractList;
import java.util.Objects;
import javaslang.Function4;
import javaslang.collection.HashMap;
import javaslang.collection.Map;
import javaslang.control.Option;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class RGA<E>
extends AbstractList<E>
implements Crdt {
    private final String crtdId;
    private final Processor<CrdtCommand, CrdtCommand> commands = PublishProcessor.create();
    private final Vertex<E> start;
    private Map<StrictVectorClock, Vertex<E>> vertices;
    private Map<Vertex<E>, Vertex<E>> edges = HashMap.empty();
    private StrictVectorClock clock;
    private int size;

    public RGA(String nodeId, String crtdId, Publisher<? extends CrdtCommand> inCommands, Subscriber<? super CrdtCommand> outCommands) {
        this.crtdId = Objects.requireNonNull(crtdId, "CrtdId must not be null");
        Objects.requireNonNull(nodeId, "NodeId must not be null");
        this.clock = new StrictVectorClock(nodeId);
        this.start = new Vertex(null, this.clock);
        this.vertices = HashMap.of((Object)this.clock, this.start);
        inCommands.subscribe((Subscriber)new CrdtSubscriber(this::processCommand));
        this.commands.subscribe(outCommands);
    }

    @Override
    public String getId() {
        return this.crtdId;
    }

    @Override
    public Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> getFactory() {
        return RGA::new;
    }

    @Override
    public E get(int index) {
        return (E)((Vertex)this.findVertex(index)).value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Vertex<E> anchor = index == 0 ? this.start : this.findVertex(index - 1);
        this.prepareAddRight(anchor, element);
    }

    @Override
    public E remove(int index) {
        Vertex<E> vertex = this.findVertex(index);
        this.prepareRemove(vertex);
        return (E)((Vertex)vertex).value;
    }

    private Vertex<E> findVertex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Vertex vertex = this.start;
        for (int i = 0; i <= index; ++i) {
            while ((vertex = (Vertex)this.edges.get(vertex).get()).removed) {
            }
        }
        return vertex;
    }

    private Option<Vertex<E>> findVertex(StrictVectorClock clock) {
        return this.vertices.get((Object)clock);
    }

    private void prepareRemove(Vertex<E> vertex) {
        this.commands.onNext((Object)new RemoveCommand(this.crtdId, ((Vertex)vertex).clock));
        this.doRemove(vertex);
    }

    private void doRemove(Vertex<E> vertex) {
        if (!((Vertex)vertex).removed) {
            ((Vertex)vertex).removed = true;
            --this.size;
        }
    }

    private void prepareAddRight(Vertex<E> anchor, E value) {
        this.clock = this.clock.increment();
        this.commands.onNext(new AddRightCommand(this.crtdId, ((Vertex)anchor).clock, value, this.clock));
        this.doAddRight(anchor, value, this.clock);
    }

    private void doAddRight(Vertex<E> l, E value, StrictVectorClock clock) {
        Option<Vertex<E>> r = this.successor(l);
        while (r.isDefined() && clock.compareTo(((Vertex)r.get()).clock) < 0) {
            l = (Vertex)r.get();
            r = this.successor(l);
        }
        Vertex w = new Vertex(value, clock);
        this.vertices = this.vertices.put((Object)clock, w);
        ++this.size;
        this.edges = this.edges.put((Object)l, w);
        if (r.isDefined()) {
            this.edges = this.edges.put(w, r.get());
        }
    }

    private Option<Vertex<E>> successor(Vertex<E> vertex) {
        return this.edges.get(vertex);
    }

    private void processCommand(CrdtCommand command) {
        Class<?> clazz = command.getClass();
        if (AddRightCommand.class.equals(clazz)) {
            AddRightCommand addRightCommand = (AddRightCommand)command;
            Option<Vertex<E>> anchor = this.findVertex(addRightCommand.anchorClock);
            this.clock = this.clock.merge(addRightCommand.newVertexClock);
            anchor.peek(vertex -> this.doAddRight((Vertex<E>)vertex, (E)addRightCommand.newVertexValue, addRightCommand.newVertexClock));
        } else if (RemoveCommand.class.equals(clazz)) {
            StrictVectorClock removedClock = ((RemoveCommand)command).clock;
            Option<Vertex<E>> vertex2 = this.findVertex(removedClock);
            vertex2.peek(this::doRemove);
        }
    }

    static final class AddRightCommand<E>
    extends CrdtCommand {
        private final StrictVectorClock anchorClock;
        private final E newVertexValue;
        private final StrictVectorClock newVertexClock;

        private AddRightCommand(String crdtId, StrictVectorClock anchorClock, E newVertexValue, StrictVectorClock newVertexClock) {
            super(crdtId);
            this.anchorClock = Objects.requireNonNull(anchorClock, "AnchorClock must not be null");
            this.newVertexValue = Objects.requireNonNull(newVertexValue, "NewVertexValue must not be null");
            this.newVertexClock = Objects.requireNonNull(newVertexClock, "NewVertexClock must not be null");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddRightCommand that = (AddRightCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.anchorClock, (Object)that.anchorClock).append(this.newVertexValue, that.newVertexValue).append((Object)this.newVertexClock, (Object)that.newVertexClock).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.anchorClock).append(this.newVertexValue).append((Object)this.newVertexClock).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("anchorClock", (Object)this.anchorClock).append("newVertexValue", this.newVertexValue).append("newVertexClock", (Object)this.newVertexClock).toString();
        }
    }

    static final class RemoveCommand
    extends CrdtCommand {
        private final StrictVectorClock clock;

        private RemoveCommand(String crtdId, StrictVectorClock clock) {
            super(crtdId);
            this.clock = clock;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveCommand that = (RemoveCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.clock, (Object)that.clock).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.clock).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("clock", (Object)this.clock).toString();
        }
    }

    static final class Vertex<E> {
        private final E value;
        private final StrictVectorClock clock;
        private boolean removed;

        private Vertex(E value, StrictVectorClock clock) {
            this.value = value;
            this.clock = clock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)o;
            return Objects.equals(this.clock, vertex.clock);
        }

        public int hashCode() {
            return this.clock.hashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("value", this.value).append("clock", (Object)this.clock).append("removed", this.removed).toString();
        }
    }
}

