/*
 * Decompiled with CFR 0.152.
 */
package com.netshoes.springframework.cloud.sleuth.instrument.amqp;

import com.netshoes.springframework.cloud.sleuth.instrument.amqp.AmqpMessagingSpanManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;

public abstract class AbstractRabbitMessageReceiverAspect {
    private final AmqpMessagingSpanManager spanManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractRabbitMessageReceiverAspect(AmqpMessagingSpanManager spanManager) {
        this.spanManager = spanManager;
    }

    protected Object executeAroundMessageReceive(ProceedingJoinPoint call) throws Throwable {
        Object[] args = call.getArgs();
        Message message = this.getMessageArgument(args);
        if (message != null) {
            this.spanManager.beforeHandle(message);
            try {
                Object result = call.proceed();
                this.spanManager.afterHandle(null);
                return result;
            }
            catch (Exception e) {
                this.spanManager.afterHandle(e);
                throw e;
            }
        }
        this.logger.debug("Ignoring execution around {}. Message argument not found.", (Object)call);
        Object result = call.proceed();
        return result;
    }

    private Message getMessageArgument(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof Message)) continue;
            return (Message)arg;
        }
        return null;
    }
}

