/*
 * Decompiled with CFR 0.152.
 */
package com.netshoes.springframework.cloud.sleuth.instrument.amqp;

import com.netshoes.springframework.cloud.sleuth.instrument.amqp.AmqpMessagingSpanManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.amqp.core.Message;

public class AmqpMessagingBeforeReceiveInterceptor
implements MethodInterceptor {
    private final AmqpMessagingSpanManager spanManager;

    public AmqpMessagingBeforeReceiveInterceptor(AmqpMessagingSpanManager spanManager) {
        this.spanManager = spanManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Message message = this.getMessageArgument(invocation.getArguments());
        if (message == null) {
            throw new IllegalStateException("Message cannot be null");
        }
        this.before(message);
        return invocation.proceed();
    }

    private void before(Message message) {
        this.spanManager.beforeHandle(message);
    }

    private Message getMessageArgument(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof Message)) continue;
            return (Message)arg;
        }
        return null;
    }
}

