/*
 * Decompiled with CFR 0.152.
 */
package com.netshoes.springframework.cloud.sleuth.instrument.amqp;

import com.netshoes.springframework.cloud.sleuth.instrument.amqp.support.AmqpMessageHeaderAccessor;
import java.util.Random;
import org.springframework.amqp.core.Message;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;

public class AmqpMessagingSpanExtractor
implements SpanExtractor<Message> {
    private final Random random;

    public AmqpMessagingSpanExtractor(Random random) {
        this.random = random;
    }

    public Span joinTrace(Message message) {
        AmqpMessageHeaderAccessor accessor = AmqpMessageHeaderAccessor.getAccessor(message);
        if (!(this.hasHeader(accessor, "X-B3-TraceId") && this.hasHeader(accessor, "X-B3-SpanId") || this.hasHeader(accessor, "spanId") && this.hasHeader(accessor, "spanTraceId"))) {
            return null;
        }
        return this.extractSpanFromHeaders(accessor, Span.builder(), "spanTraceId", "spanId", "spanSampled", "spanProcessId", "spanName", "spanParentSpanId");
    }

    private Span extractSpanFromHeaders(AmqpMessageHeaderAccessor accessor, Span.SpanBuilder spanBuilder, String traceIdHeader, String spanIdHeader, String spanSampledHeader, String spanProcessIdHeader, String spanNameHeader, String spanParentIdHeader) {
        String traceId = this.getHeader(accessor, traceIdHeader);
        spanBuilder.traceIdHigh(traceId.length() == 32 ? Span.hexToId((String)traceId, (int)0) : 0L);
        spanBuilder.traceId(Span.hexToId((String)traceId));
        long spanId = Span.hexToId((String)this.getHeader(accessor, spanIdHeader));
        spanBuilder = spanBuilder.spanId(spanId);
        spanBuilder.exportable("1".equals(this.getHeader(accessor, spanSampledHeader)));
        String processId = this.getHeader(accessor, spanProcessIdHeader);
        String spanName = this.getHeader(accessor, spanNameHeader);
        if (spanName != null) {
            spanBuilder.name(spanName);
        }
        if (processId != null) {
            spanBuilder.processId(processId);
        }
        this.setParentIdIfApplicable(accessor, spanBuilder, spanParentIdHeader);
        spanBuilder.remote(true);
        return spanBuilder.build();
    }

    private String getHeader(AmqpMessageHeaderAccessor accessor, String name) {
        return this.getHeader(accessor, name, String.class);
    }

    private <T> T getHeader(AmqpMessageHeaderAccessor accessor, String name, Class<T> type) {
        return (T)accessor.getHeader(name);
    }

    private boolean hasHeader(AmqpMessageHeaderAccessor accessor, String name) {
        return accessor.hasHeader(name);
    }

    private void setParentIdIfApplicable(AmqpMessageHeaderAccessor accessor, Span.SpanBuilder spanBuilder, String spanParentIdHeader) {
        String parentId = this.getHeader(accessor, spanParentIdHeader);
        if (parentId != null) {
            spanBuilder.parent(Long.valueOf(Span.hexToId((String)parentId)));
        }
    }
}

