/*
 * Decompiled with CFR 0.152.
 */
package com.netshoes.springframework.cloud.sleuth.instrument.amqp;

import com.netshoes.springframework.cloud.sleuth.instrument.amqp.support.AmqpMessageHeaderAccessor;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.util.StringUtils;

public class AmqpMessagingSpanInjector
implements SpanInjector {
    private static final String SPAN_HEADER = "currentSpan";
    private final TraceKeys traceKeys;

    public AmqpMessagingSpanInjector(TraceKeys traceKeys) {
        this.traceKeys = traceKeys;
    }

    public void inject(Span span, Object carrier) {
        Message message = (Message)carrier;
        AmqpMessageHeaderAccessor accessor = AmqpMessageHeaderAccessor.getAccessor(message);
        if (span == null) {
            if (!this.isSampled(message, "X-B3-Sampled") && !this.isSampled(message, "spanSampled")) {
                accessor.setHeader("spanSampled", "0");
                return;
            }
            return;
        }
        this.addHeaders(span, message, accessor);
    }

    private boolean isSampled(Message message, String sampledHeaderName) {
        return "1".equals(message.getMessageProperties().getHeaders().get(sampledHeaderName));
    }

    private void addHeaders(Span span, Message initialMessage, AmqpMessageHeaderAccessor accessor) {
        this.addHeaders(span, initialMessage, accessor, "spanTraceId", "spanId", "spanParentSpanId", "spanName", "spanProcessId", "spanSampled", SPAN_HEADER);
    }

    private void addHeaders(Span span, Message initialMessage, AmqpMessageHeaderAccessor accessor, String traceIdHeader, String spanIdHeader, String spanParentIdHeader, String spanNameHeader, String processIdHeader, String spanSampledHeader, String spanHeader) {
        this.addHeader(traceIdHeader, span.traceIdString(), accessor);
        this.addHeader(spanIdHeader, Span.idToHex((long)span.getSpanId()), accessor);
        if (span.isExportable()) {
            this.addAnnotations(this.traceKeys, initialMessage, span);
            Long parentId = this.getFirst(span.getParents());
            if (parentId != null) {
                this.addHeader(spanParentIdHeader, Span.idToHex((long)parentId), accessor);
            }
            this.addHeader(spanNameHeader, span.getName(), accessor);
            this.addHeader(processIdHeader, span.getProcessId(), accessor);
            this.addHeader(spanSampledHeader, "1", accessor);
        } else {
            this.addHeader(spanSampledHeader, "0", accessor);
        }
        accessor.setHeader(spanHeader, span);
    }

    private void addAnnotations(TraceKeys traceKeys, Message message, Span span) {
        for (String name : traceKeys.getMessage().getHeaders()) {
            MessageProperties messageProperties = message.getMessageProperties();
            Map headers = messageProperties.getHeaders();
            if (!headers.containsKey(name)) continue;
            String key = traceKeys.getMessage().getPrefix() + name.toLowerCase();
            Object value = headers.get(name);
            if (value == null) {
                value = "null";
            }
            this.tagIfEntryMissing(span, key, value.toString());
        }
        this.addPayloadAnnotations(traceKeys, message.getBody(), span);
    }

    private void addPayloadAnnotations(TraceKeys traceKeys, byte[] payload, Span span) {
        if (payload != null) {
            TraceKeys.Message.Payload traceKeyPayloadMessage = traceKeys.getMessage().getPayload();
            this.tagIfEntryMissing(span, traceKeyPayloadMessage.getType(), payload.getClass().getCanonicalName());
            this.tagIfEntryMissing(span, traceKeyPayloadMessage.getSize(), String.valueOf(payload.length));
        }
    }

    private void tagIfEntryMissing(Span span, String key, String value) {
        if (!span.tags().containsKey(key)) {
            span.tag(key, value);
        }
    }

    private void addHeader(String name, String value, AmqpMessageHeaderAccessor accessor) {
        if (StringUtils.hasText((String)value)) {
            accessor.setHeader(name, value);
        }
    }

    private Long getFirst(List<Long> parents) {
        return parents.isEmpty() ? null : parents.get(0);
    }
}

