/*
 * Decompiled with CFR 0.152.
 */
package com.netshoes.springframework.cloud.sleuth.instrument.amqp;

import com.netshoes.springframework.cloud.sleuth.instrument.amqp.AmqpMessagingSpanManager;
import com.netshoes.springframework.cloud.sleuth.instrument.amqp.CompositeMessagePostProcessor;
import com.netshoes.springframework.cloud.sleuth.instrument.amqp.SpanManagerMessagePostProcessor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

@Aspect
public class AmqpTemplateAspect {
    private static final String CONVERT_AND_SEND = "convertAndSend";
    private static final String UNKNOWN_EXCHANGE = "unknown-exchange";
    private static final String SPAN_NAME_PREFIX = "amqp://";
    private final AmqpMessagingSpanManager spanManager;

    public AmqpTemplateAspect(AmqpMessagingSpanManager spanManager) {
        this.spanManager = spanManager;
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.send(..))")
    public void executeAroundSend(ProceedingJoinPoint call) throws Throwable {
        this.executeWithoutPostProcessor(call, ArgumentDiscover.from(call));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.sendAndReceive(..))")
    public Object executeAroundSendAndReceive(ProceedingJoinPoint call) throws Throwable {
        return this.executeWithoutPostProcessor(call, ArgumentDiscover.from(call));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(Object))")
    public void executeAroundConvertAndSendOneArg(ProceedingJoinPoint call) throws Throwable {
        this.executeConvertAndSendWithoutPostProcessor(call, ArgumentDiscover.from(call));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(String,Object))")
    public void executeAroundConvertAndSendTwoArgs(ProceedingJoinPoint call) throws Throwable {
        this.executeConvertAndSendWithoutPostProcessor(call, ArgumentDiscover.from(call));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(String,String,Object))")
    public void executeAroundConvertAndSendThreeArgs(ProceedingJoinPoint call) throws Throwable {
        this.executeConvertAndSendWithoutPostProcessor(call, ArgumentDiscover.from(call));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(Object,org.springframework.amqp.core.MessagePostProcessor))")
    public void executeAroundConvertAndSendOneArgWithProcessor(ProceedingJoinPoint call) throws Throwable {
        ArgumentDiscover argumentDiscover = ArgumentDiscover.from(call);
        MessagePostProcessor argPostProcessor = argumentDiscover.messagePostProcessor;
        boolean byPass = argPostProcessor instanceof SpanManagerMessagePostProcessor;
        if (byPass) {
            call.proceed(call.getArgs());
        } else {
            this.executeConvertAndSendWithoutPostProcessor(call, argumentDiscover);
        }
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(String,Object,org.springframework.amqp.core.MessagePostProcessor))")
    public void executeAroundConvertAndSendTwoArgsWithPostProcessor(ProceedingJoinPoint call) throws Throwable {
        ArgumentDiscover argumentDiscover = ArgumentDiscover.from(call);
        MessagePostProcessor argPostProcessor = argumentDiscover.messagePostProcessor;
        boolean byPass = argPostProcessor instanceof SpanManagerMessagePostProcessor;
        if (byPass) {
            call.proceed(call.getArgs());
        } else {
            this.executeConvertAndSendWithoutPostProcessor(call, argumentDiscover);
        }
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(String,String,Object,org.springframework.amqp.core.MessagePostProcessor))")
    public void executeAroundConvertAndSendThreeArgsWithPostProcessor(ProceedingJoinPoint call) throws Throwable {
        ArgumentDiscover discoverArguments = ArgumentDiscover.from(call);
        MessagePostProcessor argPostProcessor = discoverArguments.messagePostProcessor;
        boolean byPass = argPostProcessor instanceof SpanManagerMessagePostProcessor;
        if (byPass) {
            call.proceed(call.getArgs());
        } else {
            this.executeConvertAndSendWithoutPostProcessor(call, discoverArguments);
        }
    }

    private void executeConvertAndSendWithoutPostProcessor(ProceedingJoinPoint call, ArgumentDiscover argumentDiscover) throws Throwable {
        boolean executed;
        Object[] args = argumentDiscover.args;
        MessagePostProcessor argPostProcessor = argumentDiscover.messagePostProcessor;
        try {
            if (argPostProcessor != null) {
                String exchange = argumentDiscover.exchangeOfSender;
                String routingKey = argumentDiscover.routingKey;
                SpanManagerMessagePostProcessor postProcessor = new SpanManagerMessagePostProcessor(this.spanManager, this.buildSpanName(exchange, routingKey));
                CompositeMessagePostProcessor overwritePostProcessor = new CompositeMessagePostProcessor(argPostProcessor, postProcessor);
                args[args.length - 1] = overwritePostProcessor;
                call.proceed(args);
                executed = true;
            } else {
                executed = this.changeExecutionOfMethodToUsePostProcessor(call, argumentDiscover);
            }
        }
        catch (Exception e) {
            this.spanManager.afterSend(e);
            throw e;
        }
        if (executed) {
            this.spanManager.afterSend(null);
        } else {
            this.executeWithoutPostProcessor(call, argumentDiscover);
        }
    }

    private Object executeWithoutPostProcessor(ProceedingJoinPoint call, ArgumentDiscover argumentDiscover) throws Throwable {
        Object[] args = call.getArgs();
        Message message = argumentDiscover.message;
        String exchange = argumentDiscover.exchangeOfSender;
        String routingKey = argumentDiscover.routingKey;
        this.before(message, exchange, routingKey);
        try {
            Object result = call.proceed(args);
            this.spanManager.afterSend(null);
            return result;
        }
        catch (Exception e) {
            this.spanManager.afterSend(e);
            throw e;
        }
    }

    private boolean changeExecutionOfMethodToUsePostProcessor(ProceedingJoinPoint call, ArgumentDiscover argumentDiscover) {
        Object[] args = call.getArgs();
        String exchange = argumentDiscover.exchangeOfSender;
        String routingKey = argumentDiscover.routingKey;
        SpanManagerMessagePostProcessor beforePublishPostProcessor = new SpanManagerMessagePostProcessor(this.spanManager, this.buildSpanName(exchange, routingKey));
        AmqpTemplate amqpTemplate = (AmqpTemplate)call.getTarget();
        boolean executed = true;
        int argsLength = args.length;
        switch (argsLength) {
            case 1: {
                amqpTemplate.convertAndSend(args[0], (MessagePostProcessor)beforePublishPostProcessor);
                break;
            }
            case 2: {
                amqpTemplate.convertAndSend((String)args[0], args[1], (MessagePostProcessor)beforePublishPostProcessor);
                break;
            }
            case 3: {
                amqpTemplate.convertAndSend((String)args[0], (String)args[1], args[2], (MessagePostProcessor)beforePublishPostProcessor);
                break;
            }
            default: {
                executed = false;
            }
        }
        return executed;
    }

    private void before(Message message, String exchange, String routingKey) {
        if (message != null) {
            this.spanManager.beforeSend(message, this.buildSpanName(exchange, routingKey));
        }
    }

    private String buildSpanName(String exchange, String routingKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(SPAN_NAME_PREFIX);
        sb.append(exchange != null ? exchange : UNKNOWN_EXCHANGE);
        sb.append("/");
        sb.append(routingKey);
        return sb.toString();
    }

    private static class ArgumentDiscover {
        private Message message;
        private String exchangeOfSender;
        private String routingKey = "*";
        private Object[] args;
        private Object target;
        private MessagePostProcessor messagePostProcessor;

        private ArgumentDiscover(ProceedingJoinPoint call) {
            this.args = call.getArgs();
            this.target = call.getTarget();
            String exchangeFromArgs = null;
            String methodName = call.getSignature().getName();
            int argsLength = this.args.length;
            if (AmqpTemplateAspect.CONVERT_AND_SEND.equals(methodName)) {
                if (this.args[argsLength - 1] instanceof MessagePostProcessor) {
                    if (argsLength > 3) {
                        exchangeFromArgs = (String)this.args[0];
                        this.routingKey = (String)this.args[1];
                    } else if (argsLength > 2) {
                        this.routingKey = (String)this.args[0];
                    }
                } else if (argsLength > 2) {
                    exchangeFromArgs = (String)this.args[0];
                    this.routingKey = (String)this.args[1];
                } else if (argsLength > 1) {
                    this.routingKey = (String)this.args[0];
                }
            } else if (argsLength > 1) {
                if (this.args[0] instanceof String && this.args[1] instanceof String) {
                    exchangeFromArgs = (String)this.args[0];
                    this.routingKey = (String)this.args[1];
                } else {
                    this.routingKey = (String)this.args[0];
                }
            }
            this.exchangeOfSender = exchangeFromArgs == null ? this.getExchangeFromRabbitTemplate(this.target) : exchangeFromArgs;
            for (Object arg : this.args) {
                if (arg instanceof MessagePostProcessor) {
                    this.messagePostProcessor = (MessagePostProcessor)arg;
                    continue;
                }
                if (!(arg instanceof Message)) continue;
                this.message = (Message)arg;
            }
        }

        private String getExchangeFromRabbitTemplate(Object target) {
            String exchange = null;
            if (target instanceof RabbitTemplate) {
                exchange = ((RabbitTemplate)target).getExchange();
            }
            return exchange;
        }

        public static ArgumentDiscover from(ProceedingJoinPoint call) {
            return new ArgumentDiscover(call);
        }
    }
}

