/*
 * Decompiled with CFR 0.152.
 */
package com.netshoes.springframework.cloud.sleuth.instrument.amqp;

import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;

public class CompositeMessagePostProcessor
implements MessagePostProcessor {
    private final List<MessagePostProcessor> postProcessorList = new ArrayList<MessagePostProcessor>();

    public CompositeMessagePostProcessor(MessagePostProcessor ... postProcessors) {
        for (MessagePostProcessor processor : postProcessors) {
            this.postProcessorList.add(processor);
        }
    }

    public Message postProcessMessage(Message message) throws AmqpException {
        Message localMessage = message;
        for (MessagePostProcessor postProcessor : this.postProcessorList) {
            localMessage = postProcessor.postProcessMessage(localMessage);
        }
        return localMessage;
    }
}

