/*
 * Decompiled with CFR 0.152.
 */
package com.netshoes.springframework.cloud.sleuth.instrument.amqp;

import com.netshoes.springframework.cloud.sleuth.instrument.amqp.AmqpMessagingSpanExtractor;
import com.netshoes.springframework.cloud.sleuth.instrument.amqp.AmqpMessagingSpanInjector;
import com.netshoes.springframework.cloud.sleuth.instrument.amqp.AmqpMessagingSpanManager;
import com.netshoes.springframework.cloud.sleuth.instrument.amqp.support.AmqpMessageHeaderAccessor;
import org.springframework.amqp.core.Message;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.util.ExceptionUtils;

public class DefaultAmqpMessagingSpanManager
implements AmqpMessagingSpanManager {
    private static final String MESSAGE_SENT_FROM_CLIENT = "messageSent";
    private final AmqpMessagingSpanExtractor extractor;
    private final AmqpMessagingSpanInjector injector;
    private final Tracer tracer;

    public DefaultAmqpMessagingSpanManager(AmqpMessagingSpanInjector injector, AmqpMessagingSpanExtractor extractor, Tracer tracer) {
        this.injector = injector;
        this.extractor = extractor;
        this.tracer = tracer;
    }

    @Override
    public boolean isTracing() {
        return this.tracer.isTracing();
    }

    @Override
    public void afterHandle(Exception ex) {
        Span currentSpan = this.tracer.getCurrentSpan();
        if (currentSpan != null) {
            currentSpan.logEvent("ss");
            this.addErrorTag(ex);
        }
        if (this.tracer.isTracing()) {
            this.tracer.detach(currentSpan);
        }
    }

    @Override
    public Span beforeHandle(Message message) {
        Span span = this.extractor.joinTrace(message);
        if (span != null) {
            span.logEvent("sr");
        }
        return this.tracer.continueSpan(span);
    }

    @Override
    public Span beforeSend(Message message, String spanName) {
        Span parentSpan = this.tracer.isTracing() ? this.tracer.getCurrentSpan() : this.buildSpan(message);
        Span span = this.tracer.createSpan(spanName, parentSpan);
        AmqpMessageHeaderAccessor accessor = AmqpMessageHeaderAccessor.getAccessor(message);
        if (accessor.hasHeader(MESSAGE_SENT_FROM_CLIENT)) {
            span.logEvent("sr");
        } else {
            span.logEvent("cs");
            accessor.setHeader(MESSAGE_SENT_FROM_CLIENT, Boolean.TRUE.toString());
        }
        this.injector.inject(span, message);
        return span;
    }

    @Override
    public void afterSend(Exception ex) {
        Span currentSpan = this.tracer.getCurrentSpan();
        if (this.containsServerReceived(currentSpan)) {
            currentSpan.logEvent("ss");
        } else if (currentSpan != null) {
            currentSpan.logEvent("cr");
        }
        this.addErrorTag(ex);
        this.tracer.close(currentSpan);
    }

    private boolean containsServerReceived(Span span) {
        if (span == null) {
            return false;
        }
        for (Log log : span.logs()) {
            if (!"sr".equals(log.getEvent())) continue;
            return true;
        }
        return false;
    }

    private Span buildSpan(Message message) {
        return this.extractor.joinTrace(message);
    }

    private void addErrorTag(Exception ex) {
        if (ex != null) {
            this.tracer.addTag("error", ExceptionUtils.getExceptionMessage((Throwable)ex));
        }
    }
}

