/*
 * Decompiled with CFR 0.152.
 */
package com.netshoes.springframework.cloud.sleuth.instrument.amqp.support;

import java.util.Map;
import org.springframework.amqp.core.Message;
import org.springframework.cloud.sleuth.Span;
import org.springframework.util.ObjectUtils;

public class AmqpMessageHeaderAccessor {
    private final Map<String, Object> headers;
    private boolean modified = false;

    private AmqpMessageHeaderAccessor(Message message) {
        this.headers = message.getMessageProperties().getHeaders();
    }

    public static AmqpMessageHeaderAccessor getAccessor(Message message) {
        return new AmqpMessageHeaderAccessor(message);
    }

    public void setHeader(String name, Object value) {
        this.verifyType(name, value);
        if (value != null) {
            if (!ObjectUtils.nullSafeEquals((Object)value, (Object)this.getHeader(name))) {
                this.modified = true;
                this.headers.put(name, value);
            }
        } else if (this.headers.containsKey(name)) {
            this.modified = true;
            this.headers.remove(name);
        }
    }

    public Object getHeader(String name) {
        return this.headers.get(name);
    }

    public <T> T getHeader(String name, Class<T> type) {
        return (T)this.headers.get(name);
    }

    public boolean hasHeader(String headerName) {
        return this.headers.containsKey(headerName);
    }

    protected void verifyType(String headerName, Object headerValue) {
        if (headerName != null && headerValue != null && !(headerValue instanceof String) && !(headerValue instanceof Span)) {
            throw new IllegalArgumentException("'" + headerName + "' header value must be a String");
        }
    }

    public boolean isModified() {
        return this.modified;
    }
}

