/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.info;

import com.networknt.config.Config;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuditHandler
implements HttpHandler {
    public static final String CONFIG_NAME = "audit";
    public static final String ENABLE_SIMPLE_AUDIT = "enableSimpleAudit";
    static final String SIMPLE = "simple";
    static final String HEADERS = "headers";
    static final String STATUS_CODE = "statusCode";
    static final String RESPONSE_TIME = "responseTime";
    static final String TIMESTAMPT = "timestamp";
    public static Map<String, Object> config;
    private static List<String> headerList;
    private static boolean statusCode;
    private static boolean responseTime;
    static final Logger audit;
    private final HttpHandler next;

    public SimpleAuditHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        final long start = System.currentTimeMillis();
        final LinkedHashMap<String, Object> auditMap = new LinkedHashMap<String, Object>();
        auditMap.put(TIMESTAMPT, System.currentTimeMillis());
        if (headerList != null && headerList.size() > 0) {
            for (String name : headerList) {
                auditMap.put(name, exchange.getRequestHeaders().getFirst(name));
            }
        }
        if (statusCode || responseTime) {
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    if (statusCode) {
                        auditMap.put(SimpleAuditHandler.STATUS_CODE, exchange.getStatusCode());
                    }
                    if (responseTime) {
                        auditMap.put(SimpleAuditHandler.RESPONSE_TIME, new Long(System.currentTimeMillis() - start));
                    }
                    nextListener.proceed();
                }
            });
        }
        audit.info(Config.getInstance().getMapper().writeValueAsString(auditMap));
        this.next.handleRequest(exchange);
    }

    static {
        statusCode = false;
        responseTime = false;
        audit = LoggerFactory.getLogger((String)"Audit");
        config = Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME);
        Map simpleMap = (Map)config.get(SIMPLE);
        headerList = (List)simpleMap.get(HEADERS);
        Object object = simpleMap.get(STATUS_CODE);
        if (object != null && ((Boolean)object).booleanValue()) {
            statusCode = true;
        }
        if ((object = simpleMap.get(RESPONSE_TIME)) != null && ((Boolean)object).booleanValue()) {
            responseTime = true;
        }
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        public HttpHandler wrap(HttpHandler handler) {
            return new SimpleAuditHandler(handler);
        }
    }
}

