/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.body.BodyConfig;
import com.networknt.body.BodyConverter;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(BodyHandler.class);
    static final String CONTENT_TYPE_MISMATCH = "ERR10015";
    public static final AttachmentKey<Object> REQUEST_BODY = AttachmentKey.create(Object.class);
    public static final AttachmentKey<String> REQUEST_BODY_STRING = AttachmentKey.create(String.class);
    public static final String CONFIG_NAME = "body";
    public static final BodyConfig config = (BodyConfig)Config.getInstance().getJsonObjectConfig("body", BodyConfig.class);
    private volatile HttpHandler next;

    public BodyHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("BodyHandler is loaded.");
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType != null) {
            if (exchange.isInIoThread()) {
                exchange.dispatch((HttpHandler)this);
                return;
            }
            exchange.startBlocking();
            try {
                if (contentType.startsWith("application/json")) {
                    InputStream inputStream = exchange.getInputStream();
                    String unparsedRequestBody = StringUtils.inputStreamToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (config.isCacheRequestBody()) {
                        exchange.putAttachment(REQUEST_BODY_STRING, (Object)unparsedRequestBody);
                    }
                    this.attachJsonBody(exchange, unparsedRequestBody);
                } else if (contentType.startsWith("multipart/form-data") || contentType.startsWith("application/x-www-form-urlencoded")) {
                    this.attachFormDataBody(exchange);
                }
            }
            catch (IOException e) {
                logger.error("IOException: ", (Throwable)e);
                this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, new Object[]{contentType});
                return;
            }
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    private void attachFormDataBody(HttpServerExchange exchange) throws IOException {
        FormParserFactory formParserFactory = FormParserFactory.builder().build();
        FormDataParser parser = formParserFactory.createParser(exchange);
        if (parser != null) {
            FormData formData = parser.parseBlocking();
            Map<String, Object> data = BodyConverter.convert(formData);
            exchange.putAttachment(REQUEST_BODY, data);
        }
    }

    private void attachJsonBody(HttpServerExchange exchange, String string) throws IOException {
        if (string != null) {
            Object body;
            if ((string = string.trim()).startsWith("{")) {
                body = Config.getInstance().getMapper().readValue(string, (TypeReference)new TypeReference<Map<String, Object>>(){});
            } else if (string.startsWith("[")) {
                body = Config.getInstance().getMapper().readValue(string, (TypeReference)new TypeReference<List<Object>>(){});
            } else {
                this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, new Object[]{"application/json"});
                return;
            }
            exchange.putAttachment(REQUEST_BODY, body);
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)BodyHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

