/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.TokenHelper;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.utility.ApiException;
import com.networknt.utility.ClientException;
import com.networknt.utility.ErrorResponse;
import com.networknt.utility.ModuleRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    public static final String CONFIG_NAME = "client";
    static final Logger logger = LoggerFactory.getLogger(Client.class);
    static final Integer DEFAULT_REACTOR_CONNECT_TIMEOUT = 10000;
    static final Integer DEFAULT_REACTOR_SO_TIMEOUT = 10000;
    static final String SYNC = "sync";
    static final String ASYNC = "async";
    static final String ROUTES = "routes";
    static final String MAX_CONNECTION_TOTAL = "maxConnectionTotal";
    static final String MAX_CONNECTION_PER_ROUTE = "maxConnectionPerRoute";
    static final String TIMEOUT = "timeout";
    static final String KEEP_ALIVE = "keepAlive";
    static final String TLS = "tls";
    static final String LOAD_TRUST_STORE = "loadTrustStore";
    static final String LOAD_KEY_STORE = "loadKeyStore";
    static final String VERIFY_HOSTNAME = "verifyHostname";
    static final String TRUST_STORE = "trustStore";
    static final String TRUST_PASS = "trustPass";
    static final String KEY_STORE = "keyStore";
    static final String KEY_PASS = "keyPass";
    static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    static final String TRUST_STORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    static final String REACTOR = "reactor";
    static final String REACTOR_IO_THREAD_COUNT = "ioThreadCount";
    static final String REACTOR_CONNECT_TIMEOUT = "connectTimeout";
    static final String REACTOR_SO_TIMEOUT = "soTimeout";
    static final String OAUTH = "oauth";
    static final String TOKEN_RENEW_BEFORE_EXPIRED = "tokenRenewBeforeExpired";
    static final String EXPIRED_REFRESH_RETRY_DELAY = "expiredRefreshRetryDelay";
    static final String EARLY_REFRESH_RETRY_DELAY = "earlyRefreshRetryDelay";
    static Map<String, Object> config;
    static Map<String, Object> oauthConfig;
    private CloseableHttpClient httpClient = null;
    private CloseableHttpAsyncClient httpAsyncClient = null;
    private String jwt;
    private long expire;
    private volatile boolean renewing = false;
    private volatile long expiredRefreshRetryDelay;
    private volatile long earlyRefreshRetryDelay;
    private final Object lock = new Object();
    private static final Client instance;

    public static Client getInstance() {
        return instance;
    }

    private Client() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CloseableHttpClient getSyncClient() throws ClientException {
        if (this.httpClient != null) return this.httpClient;
        Class<Client> clazz = Client.class;
        synchronized (Client.class) {
            if (this.httpClient != null) return this.httpClient;
            this.httpClient = this.httpClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.httpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CloseableHttpAsyncClient getAsyncClient() throws ClientException {
        if (this.httpAsyncClient == null) {
            Class<Client> clazz = Client.class;
            // MONITORENTER : com.networknt.client.Client.class
            if (this.httpAsyncClient == null) {
                this.httpAsyncClient = this.httpAsyncClient();
            }
            // MONITOREXIT : clazz
        }
        this.httpAsyncClient.start();
        return this.httpAsyncClient;
    }

    public void addAuthorization(HttpRequest request, String token) {
        if (!token.startsWith("Bearer ")) {
            token = token.toUpperCase().startsWith("BEARER ") ? "Bearer " + token.substring(7) : "Bearer " + token;
        }
        request.addHeader("Authorization", token);
    }

    public void addAuthorization(HttpRequest request) throws ClientException, ApiException {
        this.checkCCTokenExpired();
        request.addHeader("Authorization", "Bearer " + this.jwt);
    }

    public void addAuthorizationWithScopeToken(HttpRequest request, String token) throws ClientException, ApiException {
        this.addAuthorization(request, token);
        this.checkCCTokenExpired();
        request.addHeader("scope_token", "Bearer " + this.jwt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCCToken() throws ClientException {
        ClientCredentialsRequest tokenRequest = new ClientCredentialsRequest();
        TokenResponse tokenResponse = TokenHelper.getToken(tokenRequest);
        Object object = this.lock;
        synchronized (object) {
            this.jwt = tokenResponse.getAccessToken();
            this.expire = System.currentTimeMillis() + tokenResponse.getExpiresIn() * 1000L;
            logger.info("Get client credentials token {} with expire_in {} seconds", (Object)this.jwt, (Object)tokenResponse.getExpiresIn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkCCTokenExpired() throws ClientException, ApiException {
        boolean isInRenewWindow;
        long tokenRenewBeforeExpired = ((Integer)oauthConfig.get(TOKEN_RENEW_BEFORE_EXPIRED)).intValue();
        long expiredRefreshRetryDelay = ((Integer)oauthConfig.get(EXPIRED_REFRESH_RETRY_DELAY)).intValue();
        long earlyRefreshRetryDelay = ((Integer)oauthConfig.get(EARLY_REFRESH_RETRY_DELAY)).intValue();
        boolean bl = isInRenewWindow = this.expire - System.currentTimeMillis() < tokenRenewBeforeExpired;
        if (isInRenewWindow) {
            if (this.expire <= System.currentTimeMillis()) {
                logger.trace("In renew window and token is expired.");
                Class<Client> clazz = Client.class;
                // MONITORENTER : com.networknt.client.Client.class
                if (this.expire <= System.currentTimeMillis()) {
                    logger.trace("Within the synch block, check if the current request need to renew token...");
                    if (this.renewing && System.currentTimeMillis() <= expiredRefreshRetryDelay) {
                        logger.trace("Circuit breaker is tripped and not timeout yet!");
                        throw new ApiException(new ErrorResponse(408, "Client credentials token is not available"));
                    }
                    this.renewing = true;
                    expiredRefreshRetryDelay = System.currentTimeMillis() + expiredRefreshRetryDelay;
                    logger.trace("Current request is renewing token synchronously as token is expired already");
                    this.getCCToken();
                    this.renewing = false;
                }
                // MONITOREXIT : clazz
            } else {
                logger.trace("In renew window but token is not expired yet.");
                Class<Client> clazz = Client.class;
                // MONITORENTER : com.networknt.client.Client.class
                if (!(this.expire <= System.currentTimeMillis() || this.renewing && System.currentTimeMillis() <= earlyRefreshRetryDelay)) {
                    this.renewing = true;
                    earlyRefreshRetryDelay = System.currentTimeMillis() + earlyRefreshRetryDelay;
                    logger.trace("Retrieve token async is called while token is not expired yet");
                    ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
                    executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Client.this.getCCToken();
                                Client.this.renewing = false;
                                logger.trace("Async get token is completed.");
                            }
                            catch (Exception e) {
                                logger.error("Async retrieve token error", (Throwable)e);
                            }
                        }
                    }, 50L, TimeUnit.MILLISECONDS);
                    executor.shutdown();
                }
                // MONITOREXIT : clazz
            }
        }
        logger.trace("Check secondary token is done!");
    }

    private CloseableHttpClient httpClient() throws ClientException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(this.registry());
        Map httpClientMap = (Map)config.get(SYNC);
        connectionManager.setMaxTotal(((Integer)httpClientMap.get(MAX_CONNECTION_TOTAL)).intValue());
        connectionManager.setDefaultMaxPerRoute(((Integer)httpClientMap.get(MAX_CONNECTION_PER_ROUTE)).intValue());
        Map routeMap = (Map)httpClientMap.get(ROUTES);
        for (String route : routeMap.keySet()) {
            Integer maxConnection = (Integer)routeMap.get(route);
            connectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(route)), maxConnection.intValue());
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(((Integer)httpClientMap.get(TIMEOUT)).intValue()).build();
        final long keepAliveMilliseconds = ((Integer)httpClientMap.get(KEEP_ALIVE)).intValue();
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase(Client.TIMEOUT)) continue;
                    try {
                        logger.trace("Use server timeout for keepAliveMilliseconds");
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                logger.trace("Use keepAliveMilliseconds from config " + keepAliveMilliseconds);
                return keepAliveMilliseconds;
            }
        }).setDefaultRequestConfig(config).build();
    }

    private CloseableHttpAsyncClient httpAsyncClient() throws ClientException {
        PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager(this.ioReactor(), this.asyncRegistry());
        Map asyncHttpClientMap = (Map)config.get(ASYNC);
        connectionManager.setMaxTotal(((Integer)asyncHttpClientMap.get(MAX_CONNECTION_TOTAL)).intValue());
        connectionManager.setDefaultMaxPerRoute(((Integer)asyncHttpClientMap.get(MAX_CONNECTION_PER_ROUTE)).intValue());
        Map routeMap = (Map)asyncHttpClientMap.get(ROUTES);
        for (String route : routeMap.keySet()) {
            Integer maxConnection = (Integer)routeMap.get(route);
            connectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(route)), maxConnection.intValue());
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(((Integer)asyncHttpClientMap.get(TIMEOUT)).intValue()).build();
        final long keepAliveMilliseconds = ((Integer)asyncHttpClientMap.get(KEEP_ALIVE)).intValue();
        return HttpAsyncClientBuilder.create().setConnectionManager((NHttpClientConnectionManager)connectionManager).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase(Client.TIMEOUT)) continue;
                    try {
                        logger.trace("Use server timeout for keepAliveMilliseconds");
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                logger.trace("Use keepAliveMilliseconds from config " + keepAliveMilliseconds);
                return keepAliveMilliseconds;
            }
        }).setDefaultRequestConfig(config).build();
    }

    private Registry<SchemeIOSessionStrategy> asyncRegistry() throws ClientException {
        Registry registry = null;
        try {
            SSLIOSessionStrategy sslSessionStrategy = new SSLIOSessionStrategy(this.sslContext(), new String[]{"TLSv1"}, null, this.hostnameVerifier());
            registry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)sslSessionStrategy).build();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("NoSuchAlgorithmException: ", (Throwable)e);
            throw new ClientException("NoSuchAlgorithmException: ", (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error("KeyManagementException: ", (Throwable)e);
            throw new ClientException("KeyManagementException: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException: ", (Throwable)e);
            throw new ClientException("IOException: ", (Throwable)e);
        }
        return registry;
    }

    private ConnectingIOReactor ioReactor() throws ClientException {
        Map asyncMap = (Map)config.get(ASYNC);
        Map reactorMap = (Map)asyncMap.get(REACTOR);
        Integer ioThreadCount = (Integer)reactorMap.get(REACTOR_IO_THREAD_COUNT);
        IOReactorConfig.Builder builder = IOReactorConfig.custom();
        builder.setIoThreadCount(ioThreadCount == null ? Runtime.getRuntime().availableProcessors() : ioThreadCount.intValue());
        Integer connectTimeout = (Integer)reactorMap.get(REACTOR_CONNECT_TIMEOUT);
        builder.setConnectTimeout((connectTimeout == null ? DEFAULT_REACTOR_CONNECT_TIMEOUT : connectTimeout).intValue());
        Integer soTimeout = (Integer)reactorMap.get(REACTOR_SO_TIMEOUT);
        builder.setSoTimeout((soTimeout == null ? DEFAULT_REACTOR_SO_TIMEOUT : soTimeout).intValue());
        DefaultConnectingIOReactor reactor = null;
        try {
            reactor = new DefaultConnectingIOReactor(builder.build());
        }
        catch (IOReactorException e) {
            logger.error("IOReactorException: ", (Throwable)e);
            throw new ClientException("IOReactorException: ", (Throwable)e);
        }
        return reactor;
    }

    private SSLContext sslContext() throws ClientException, IOException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = null;
        Map tlsMap = (Map)config.get(TLS);
        if (tlsMap != null) {
            Boolean loadKeyStore;
            SSLContextBuilder builder = SSLContexts.custom();
            Boolean loadTrustStore = (Boolean)tlsMap.get(LOAD_TRUST_STORE);
            if (loadTrustStore != null && loadTrustStore.booleanValue()) {
                InputStream trustStream;
                String trustStoreName = System.getProperty(TRUST_STORE_PROPERTY);
                String trustStorePass = System.getProperty(TRUST_STORE_PASSWORD_PROPERTY);
                if (trustStoreName != null && trustStorePass != null) {
                    logger.info("Loading trust store from system property at " + Encode.forJava((String)trustStoreName));
                } else {
                    trustStoreName = (String)tlsMap.get(TRUST_STORE);
                    trustStorePass = (String)tlsMap.get(TRUST_PASS);
                    logger.info("Loading trust store from config at " + Encode.forJava((String)trustStoreName));
                }
                KeyStore trustStore = null;
                if (trustStoreName != null && trustStorePass != null && (trustStream = Config.getInstance().getInputStreamFromFile(trustStoreName)) != null) {
                    try {
                        trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        trustStore.load(trustStream, trustStorePass.toCharArray());
                        builder.loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy());
                    }
                    catch (CertificateException ce) {
                        logger.error("CertificateException: Unable to load trust store.", (Throwable)ce);
                        throw new ClientException("CertificateException: Unable to load trust store.", (Throwable)ce);
                    }
                    catch (KeyStoreException kse) {
                        logger.error("KeyStoreException: Unable to load trust store.", (Throwable)kse);
                        throw new ClientException("KeyStoreException: Unable to load trust store.", (Throwable)kse);
                    }
                    finally {
                        trustStream.close();
                    }
                }
            }
            if ((loadKeyStore = (Boolean)tlsMap.get(LOAD_KEY_STORE)) != null && loadKeyStore.booleanValue()) {
                InputStream keyStream;
                String keyStoreName = (String)tlsMap.get(KEY_STORE);
                String keyStorePass = (String)tlsMap.get(KEY_PASS);
                KeyStore keyStore = null;
                if (keyStoreName != null && keyStorePass != null && (keyStream = Config.getInstance().getInputStreamFromFile(keyStoreName)) != null) {
                    try {
                        keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore.load(keyStream, keyStorePass.toCharArray());
                        builder.loadKeyMaterial(keyStore, keyStorePass.toCharArray());
                    }
                    catch (CertificateException ce) {
                        logger.error("CertificateException: Unable to load key store.", (Throwable)ce);
                        throw new ClientException("CertificateException: Unable to load key store.", (Throwable)ce);
                    }
                    catch (KeyStoreException kse) {
                        logger.error("KeyStoreException: Unable to load key store.", (Throwable)kse);
                        throw new ClientException("KeyStoreException: Unable to load key store.", (Throwable)kse);
                    }
                    catch (UnrecoverableKeyException uke) {
                        logger.error("UnrecoverableKeyException: Unable to load key store.", (Throwable)uke);
                        throw new ClientException("UnrecoverableKeyException: Unable to load key store.", (Throwable)uke);
                    }
                    finally {
                        keyStream.close();
                    }
                }
            }
            sslContext = builder.build();
        }
        return sslContext;
    }

    private HostnameVerifier hostnameVerifier() {
        Map tlsMap = (Map)config.get(TLS);
        Object verifier = null;
        if (tlsMap != null) {
            Boolean verifyHostname = (Boolean)tlsMap.get(VERIFY_HOSTNAME);
            verifier = verifyHostname != null && verifyHostname == false ? new NoopHostnameVerifier() : new DefaultHostnameVerifier();
        }
        return verifier;
    }

    private Registry<ConnectionSocketFactory> registry() throws ClientException {
        Registry registry = null;
        try {
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(this.sslContext(), new String[]{"TLSv1"}, null, this.hostnameVerifier());
            registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslFactory).build();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("NoSuchAlgorithmException: in registry", (Throwable)e);
            throw new ClientException("NoSuchAlgorithmException: in registry", (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error("KeyManagementException: in registry", (Throwable)e);
            throw new ClientException("KeyManagementException: in registry", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException: in registry", (Throwable)e);
            throw new ClientException("IOException: in registry", (Throwable)e);
        }
        return registry;
    }

    static {
        ArrayList<String> masks = new ArrayList<String>();
        masks.add(TRUST_PASS);
        masks.add(KEY_PASS);
        ModuleRegistry.registerModule((String)Client.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), masks);
        config = Config.getInstance().getJsonMapConfig(CONFIG_NAME);
        if (config != null) {
            oauthConfig = (Map)config.get(OAUTH);
        }
        instance = new Client();
    }
}

