/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.client.Client;
import com.networknt.client.oauth.AuthorizationCodeRequest;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.utility.ClientException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenHelper {
    static final String BASIC = "Basic";
    static final String GRANT_TYPE = "grant_type";
    static final String CODE = "code";
    static final int HTTP_OK = 200;
    static final Logger logger = LoggerFactory.getLogger(TokenHelper.class);

    public static TokenResponse getToken(TokenRequest tokenRequest) throws ClientException {
        String url = tokenRequest.getServerUrl() + tokenRequest.getUri();
        TokenResponse tokenResponse = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Authorization", TokenHelper.getBasicAuthHeader(tokenRequest.getClientId(), tokenRequest.getClientSecret()));
        try {
            CloseableHttpClient client = Client.getInstance().getSyncClient();
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            tokenResponse = TokenHelper.handleResponse((HttpResponse)response);
        }
        catch (JsonProcessingException jpe) {
            logger.error("JsonProcessingException: ", (Throwable)jpe);
            throw new ClientException("JsonProcessingException: ", (Throwable)jpe);
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("UnsupportedEncodingException", (Throwable)uee);
            throw new ClientException("UnsupportedEncodingException: ", (Throwable)uee);
        }
        catch (IOException ioe) {
            logger.error("IOException: ", (Throwable)ioe);
            throw new ClientException("IOException: ", (Throwable)ioe);
        }
        return tokenResponse;
    }

    public static String getBasicAuthHeader(String clientId, String clientSecret) {
        return "Basic " + TokenHelper.encodeCredentials(clientId, clientSecret);
    }

    public static String encodeCredentials(String clientId, String clientSecret) {
        String cred = "";
        cred = clientSecret != null ? clientId + ":" + clientSecret : clientId;
        String encodedValue = null;
        byte[] encodedBytes = Base64.encodeBase64((byte[])cred.getBytes());
        encodedValue = new String(encodedBytes);
        return encodedValue;
    }

    public static String decodeCredentials(String cred) {
        return new String(Base64.decodeBase64((String)cred));
    }

    private static StringEntity getEntity(TokenRequest request) throws JsonProcessingException, UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(GRANT_TYPE, request.getGrantType());
        if (TokenRequest.AUTHORIZATION_CODE.equals(request.getGrantType())) {
            map.put(CODE, ((AuthorizationCodeRequest)request).getAuthCode());
            map.put(TokenRequest.REDIRECT_URI, ((AuthorizationCodeRequest)request).getRedirectUri());
        }
        if (request.getScope() != null) {
            map.put(TokenRequest.SCOPE, StringUtils.join(request.getScope(), (String)" "));
        }
        return new StringEntity(Config.getInstance().getMapper().writeValueAsString(map));
    }

    private static TokenResponse handleResponse(HttpResponse response) throws ClientException {
        TokenResponse tokenResponse = null;
        int statusCode = response.getStatusLine().getStatusCode();
        try {
            if (statusCode != 200) {
                logger.error("Error in token retrieval, response = " + Encode.forJava((String)EntityUtils.toString((HttpEntity)response.getEntity())));
                throw new ClientException("Error in token retrieval, status code = " + statusCode);
            }
            tokenResponse = (TokenResponse)Config.getInstance().getMapper().readValue(response.getEntity().getContent(), TokenResponse.class);
        }
        catch (ParseException e) {
            logger.error("Error in token retrieval", (Throwable)e);
            throw new ClientException("Error in token retrieval", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error in token retrieval", (Throwable)e);
            throw new ClientException("Error in token retrieval", (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error("Error in token retrieval", (Throwable)e);
            throw new ClientException("Error in token retrieval", (Throwable)e);
        }
        return tokenResponse;
    }
}

