/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.owasp.encoder.Encode;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public abstract class Config {
    protected Config() {
    }

    public abstract Map<String, Object> getJsonMapConfig(String var1);

    public abstract Map<String, Object> getJsonMapConfigNoCache(String var1);

    public abstract JsonNode getJsonNodeConfig(String var1);

    public abstract Object getJsonObjectConfig(String var1, Class var2);

    public abstract String getStringFromFile(String var1);

    public abstract InputStream getInputStreamFromFile(String var1);

    public abstract ObjectMapper getMapper();

    public abstract void clear();

    public static Config getInstance() {
        return FileConfigImpl.DEFAULT;
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private static final class FileConfigImpl
    extends Config {
        static final String CONFIG_EXT_JSON = ".json";
        static final XLogger logger = XLoggerFactory.getXLogger(Config.class);
        static final String EXTERNALIZED_PROPERTY_DIR = System.getProperty("undertow-server-config-dir", "");
        private long cacheExpirationTime = 0L;
        private static final Config DEFAULT = FileConfigImpl.initialize();
        Map<String, Object> configCache = new ConcurrentHashMap<String, Object>(10, 0.9f, 1);
        ObjectMapper mapper = new ObjectMapper();

        private FileConfigImpl() {
        }

        private static Config initialize() {
            Iterator<Config> it = null;
            it = ServiceLoader.load(Config.class).iterator();
            return it != null && it.hasNext() ? it.next() : new FileConfigImpl();
        }

        @Override
        public ObjectMapper getMapper() {
            return this.mapper;
        }

        @Override
        public void clear() {
            this.configCache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getStringFromFile(String filename) {
            this.checkCacheExpiration();
            String content = (String)this.configCache.get(filename);
            if (content != null) return content;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                content = (String)this.configCache.get(filename);
                if (content != null || (content = this.loadStringFromFile(filename)) == null) return content;
                this.configCache.put(filename, content);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return content;
            }
        }

        @Override
        public InputStream getInputStreamFromFile(String filename) {
            return this.getConfigStream(filename);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getJsonObjectConfig(String configName, Class clazz) {
            this.checkCacheExpiration();
            Object config = this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz2 = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = this.configCache.get(configName);
                if (config != null || (config = this.loadJsonObjectConfig(configName, clazz)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return config;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public JsonNode getJsonNodeConfig(String configName) {
            this.checkCacheExpiration();
            JsonNode config = (JsonNode)this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = (JsonNode)this.configCache.get(configName);
                if (config != null || (config = this.loadJsonNodeConfig(configName)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return config;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Map<String, Object> getJsonMapConfig(String configName) {
            this.checkCacheExpiration();
            Map<String, Object> config = (Map<String, Object>)this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = (Map)this.configCache.get(configName);
                if (config != null || (config = this.loadJsonMapConfig(configName)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return config;
            }
        }

        @Override
        public Map<String, Object> getJsonMapConfigNoCache(String configName) {
            return this.loadJsonMapConfig(configName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String loadStringFromFile(String filename) {
            String content = null;
            InputStream inStream = null;
            try {
                inStream = this.getConfigStream(filename);
                if (inStream != null) {
                    content = FileConfigImpl.convertStreamToString(inStream);
                }
            }
            catch (Exception ioe) {
                logger.catching((Throwable)ioe);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {
                        logger.catching((Throwable)ioe);
                    }
                }
            }
            return content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object loadJsonObjectConfig(String configName, Class clazz) {
            Object config = null;
            String configFilename = configName + CONFIG_EXT_JSON;
            InputStream inStream = null;
            try {
                inStream = this.getConfigStream(configFilename);
                if (inStream != null) {
                    config = this.mapper.readValue(inStream, clazz);
                }
            }
            catch (IOException ioe) {
                logger.catching((Throwable)ioe);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {
                        logger.catching((Throwable)ioe);
                    }
                }
            }
            return config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JsonNode loadJsonNodeConfig(String configName) {
            JsonNode config = null;
            String configFilename = configName + CONFIG_EXT_JSON;
            InputStream inStream = null;
            try {
                inStream = this.getConfigStream(configFilename);
                if (inStream != null) {
                    config = (JsonNode)this.mapper.readValue(inStream, JsonNode.class);
                }
            }
            catch (IOException ioe) {
                logger.catching((Throwable)ioe);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {
                        logger.catching((Throwable)ioe);
                    }
                }
            }
            return config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> loadJsonMapConfig(String configName) {
            Map config = null;
            String configFilename = configName + CONFIG_EXT_JSON;
            InputStream inStream = null;
            try {
                inStream = this.getConfigStream(configFilename);
                if (inStream != null) {
                    config = (Map)this.mapper.readValue(inStream, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                }
            }
            catch (IOException ioe) {
                logger.catching((Throwable)ioe);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {
                        logger.catching((Throwable)ioe);
                    }
                }
            }
            return config;
        }

        private InputStream getConfigStream(String configFilename) {
            InputStream inStream = null;
            try {
                inStream = new FileInputStream(EXTERNALIZED_PROPERTY_DIR + "/" + configFilename);
            }
            catch (FileNotFoundException ex) {
                logger.info("Unable to load config from externalized folder for " + Encode.forJava((String)(configFilename + " in " + EXTERNALIZED_PROPERTY_DIR)));
            }
            if (inStream != null) {
                logger.info("Config loaded from externalized folder for " + Encode.forJava((String)(configFilename + " in " + EXTERNALIZED_PROPERTY_DIR)));
                return inStream;
            }
            inStream = this.getClass().getClassLoader().getResourceAsStream("config/" + configFilename);
            if (inStream != null) {
                logger.info("Config loaded from default folder for " + Encode.forJava((String)configFilename));
                return inStream;
            }
            logger.error("Unable to load config " + Encode.forJava((String)configFilename));
            return inStream;
        }

        private static long getNextMidNightTime() {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            ((Calendar)cal).add(5, 1);
            return cal.getTimeInMillis();
        }

        private void checkCacheExpiration() {
            if (System.currentTimeMillis() > this.cacheExpirationTime) {
                this.clear();
                logger.info("daily config cache refresh");
                this.cacheExpirationTime = FileConfigImpl.getNextMidNightTime();
            }
        }
    }
}

