/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config;

import com.networknt.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsUtil {
    static final Logger logger = LoggerFactory.getLogger(TlsUtil.class);

    /*
     * Loose catch block
     */
    public static KeyStore loadKeyStore(String name, char[] password) {
        InputStream stream = null;
        try {
            stream = Config.getInstance().getInputStreamFromFile(name);
            if (stream == null) {
                String message = "Unable to load keystore '" + name + "', please provide the keystore matching the configuration in client.yml/server.yml to enable TLS connection.";
                if (logger.isErrorEnabled()) {
                    logger.error(message);
                }
                throw new RuntimeException(message);
            }
            try {
                KeyStore loadedKeystore = KeyStore.getInstance("JKS");
                loadedKeystore.load(stream, password);
                KeyStore keyStore = loadedKeystore;
                return keyStore;
            }
            catch (Exception e) {
                KeyStore keyStore;
                block20: {
                    stream.close();
                    stream = Config.getInstance().getInputStreamFromFile(name);
                    KeyStore loadedKeystore = KeyStore.getInstance("PKCS12");
                    loadedKeystore.load(stream, password);
                    keyStore = loadedKeystore;
                    if (stream == null) break block20;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        logger.error("Unable to close stream for keystore " + name, (Throwable)e2);
                    }
                }
                return keyStore;
                {
                    catch (Exception e2) {
                        try {
                            logger.error("Unable to load keystore " + name, (Throwable)e2);
                            throw new RuntimeException("Unable to load keystore " + name, e2);
                        }
                        catch (Exception e3) {
                            logger.error("Unable to load stream for keystore " + name, (Throwable)e3);
                            throw new RuntimeException("Unable to load stream for keystore " + name, e3);
                        }
                    }
                }
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error("Unable to close stream for keystore " + name, (Throwable)e);
                }
            }
        }
    }
}

