/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config.schema;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class AnnotationUtils {
    public static Element safeGetElement(String canonicalName, ProcessingEnvironment processingEnvironment) {
        try {
            return processingEnvironment.getElementUtils().getTypeElement(canonicalName);
        }
        catch (MirroredTypeException e) {
            return processingEnvironment.getTypeUtils().asElement(e.getTypeMirror());
        }
    }

    public static boolean elementIsClass(Element element, Class<?> clazz, ProcessingEnvironment processingEnvironment) {
        Optional<Class<?>> elementClass = AnnotationUtils.getClassFromElement(element, processingEnvironment);
        return elementClass.map(aClass -> aClass.equals(clazz)).orElse(false);
    }

    public static boolean elementImplementsClass(Element element, Class<?> clazz, ProcessingEnvironment processingEnv) {
        Optional<Class<?>> elementClass = AnnotationUtils.getClassFromElement(element, processingEnv);
        if (elementClass.isEmpty()) {
            return false;
        }
        for (Class<?> implementedInterface : elementClass.get().getInterfaces()) {
            if (!implementedInterface.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Class<?>> getClassFromElement(Element element, ProcessingEnvironment processingEnv) {
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(element.toString());
        try {
            return Optional.of(Class.forName(typeElement.toString()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static <A extends Annotation> Optional<A> safeGetAnnotation(Element element, Class<A> annotationClass) {
        return AnnotationUtils.safeGetAnnotation(element, annotationClass, null);
    }

    public static <A extends Annotation> Optional<A> safeGetAnnotation(Element element, Class<A> annotationClass, ProcessingEnvironment processingEnvironment) {
        if (element == null || annotationClass == null) {
            return Optional.empty();
        }
        try {
            A annotation = element.getAnnotation(annotationClass);
            if (annotation == null) {
                return Optional.empty();
            }
            return Optional.of(annotation);
        }
        catch (MirroredTypeException e) {
            TypeMirror typeMirror = e.getTypeMirror();
            if (processingEnvironment == null) {
                return Optional.empty();
            }
            TypeElement typeElement = (TypeElement)processingEnvironment.getTypeUtils().asElement(typeMirror);
            A annotation = typeElement.getAnnotation(annotationClass);
            if (annotation == null) {
                return Optional.empty();
            }
            return Optional.of(annotation);
        }
    }

    public static <T> void updateIfNotDefault(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property, String key, Object defaultValue, Class<T> type) {
        T value = AnnotationUtils.getAsType(field.get(key), type);
        AnnotationUtils.updateIfNotDefault(property, value, key, defaultValue);
    }

    public static <T> void updateIfNotDefault(LinkedHashMap<String, Object> property, T value, String key, Object defaultValue) {
        if (value != null && !Objects.equals(value, defaultValue)) {
            property.put(key, value);
        }
    }

    public static <T> T getAsType(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return null;
    }
}

