/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulResponse;
import com.networknt.consul.ConsulService;
import com.networknt.consul.client.ConsulClient;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.utility.StringUtils;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;
import org.xnio.OptionMap;

public class ConsulClientImpl
implements ConsulClient {
    private static final Logger logger = LoggerFactory.getLogger(ConsulClientImpl.class);
    private static final ConsulConfig config = (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    private static final int UNUSUAL_STATUS_CODE = 300;
    private Http2Client client = Http2Client.getInstance();
    private ConcurrentHashMap<String, ConsulConnection> connectionPool = new ConcurrentHashMap();
    private ConsulConnection http2Connection = new ConsulConnection();
    private OptionMap optionMap;
    private URI uri;
    private int maxReqPerConn;
    private String wait = "600s";
    private final String REGISTER_CONNECTION_KEY = "http2ConnectionKey";
    private final String UNREGISTER_CONNECTION_KEY = "unregisterConnectionKey";
    private final String CHECK_PASS_CONNECTION_KEY = "checkPassConnectionKey";
    private final String CHECK_FAIL_CONNECTION_KEY = "checkFailConnectionKey";

    public ConsulClientImpl() {
        String consulUrl = config.getConsulUrl().toLowerCase();
        this.optionMap = config.isEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY;
        logger.debug("url = {}", (Object)consulUrl);
        if (config.getWait() != null && config.getWait().length() > 2) {
            this.wait = config.getWait();
        }
        logger.debug("wait = {}", (Object)this.wait);
        try {
            this.uri = new URI(consulUrl);
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI " + consulUrl, (Throwable)e);
            throw new RuntimeException("Invalid URI " + consulUrl, e);
        }
        this.maxReqPerConn = config.getMaxReqPerConn() > 0 ? config.getMaxReqPerConn() : 1000000;
    }

    @Override
    public void checkPass(String serviceId, String token) {
        logger.debug("checkPass serviceId = {}", (Object)serviceId);
        String path = "/v1/agent/check/pass/service:" + serviceId;
        try {
            ConsulConnection consulConnection = this.getConnection("checkPassConnectionKey");
            AtomicReference<ClientResponse> reference = consulConnection.send(Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to checkPass on Consul: {} : {}", (Object)statusCode, reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                throw new Exception("Failed to checkPass on Consul: " + statusCode + ":" + (String)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
        }
        catch (Exception e) {
            logger.error("CheckPass request exception", (Throwable)e);
        }
    }

    @Override
    public void checkFail(String serviceId, String token) {
        logger.debug("checkFail serviceId = {}", (Object)serviceId);
        String path = "/v1/agent/check/fail/service:" + serviceId;
        try {
            ConsulConnection consulConnection = this.getConnection("checkFailConnectionKey");
            AtomicReference<ClientResponse> reference = consulConnection.send(Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to checkFail on Consul: {} : {}", (Object)statusCode, reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
        }
        catch (Exception e) {
            logger.error("CheckFail request exception", (Throwable)e);
        }
    }

    @Override
    public void registerService(ConsulService service, String token) {
        String json = service.toString();
        String path = "/v1/agent/service/register";
        try {
            ConsulConnection consulConnection = this.getConnection("http2ConnectionKey");
            AtomicReference<ClientResponse> reference = consulConnection.send(Methods.PUT, path, token, json);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                throw new Exception("Failed to register on Consul: " + statusCode);
            }
        }
        catch (Exception e) {
            logger.error("Failed to register on Consul, Exception:", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void unregisterService(String serviceId, String token) {
        String path = "/v1/agent/service/deregister/" + serviceId;
        try {
            ConsulConnection connection = this.getConnection("unregisterConnectionKey");
            AtomicReference<ClientResponse> reference = connection.send(Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to unregister on Consul, body = {}", reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
        }
        catch (Exception e) {
            logger.error("Failed to unregister on Consul, Exception:", (Throwable)e);
        }
    }

    @Override
    public ConsulResponse<List<ConsulService>> lookupHealthService(String serviceName, String tag, long lastConsulIndex, String token) {
        ConsulResponse<ArrayList<ConsulService>> newResponse = null;
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            return null;
        }
        ConsulConnection connection = this.getConnection(serviceName);
        String path = "/v1/health/service/" + serviceName + "?passing&wait=" + this.wait + "&index=" + lastConsulIndex;
        if (tag != null) {
            path = path + "&tag=" + tag;
        }
        logger.debug("path = {}", (Object)path);
        try {
            AtomicReference<ClientResponse> reference = connection.send(Methods.GET, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                throw new Exception("Failed to unregister on Consul: " + statusCode);
            }
            String body = (String)reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            List services = (List)Config.getInstance().getMapper().readValue(body, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            ArrayList<ConsulService> ConsulServcies = new ArrayList<ConsulService>(services.size());
            for (Map service : services) {
                ConsulService newService = this.convertToConsulService((Map)service.get("Service"));
                ConsulServcies.add(newService);
            }
            if (!ConsulServcies.isEmpty()) {
                newResponse = new ConsulResponse<ArrayList<ConsulService>>();
                newResponse.setValue(ConsulServcies);
                newResponse.setConsulIndex(Long.parseLong(reference.get().getResponseHeaders().getFirst("X-Consul-Index")));
                newResponse.setConsulLastContact(Long.parseLong(reference.get().getResponseHeaders().getFirst("X-Consul-Lastcontact")));
                newResponse.setConsulKnownLeader(Boolean.parseBoolean(reference.get().getResponseHeaders().getFirst("X-Consul-Knownleader")));
            }
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        return newResponse;
    }

    private ConsulService convertToConsulService(Map<String, Object> serviceMap) {
        ConsulService service = new ConsulService();
        service.setAddress((String)serviceMap.get("Address"));
        service.setId((String)serviceMap.get("ID"));
        service.setName((String)serviceMap.get("Service"));
        service.setPort((Integer)serviceMap.get("Port"));
        service.setTags((List)serviceMap.get("Tags"));
        return service;
    }

    private ConsulConnection getConnection(String cacheKey) {
        if (config.isEnableHttp2() && config.getConsulUrl().toLowerCase().startsWith("https")) {
            return this.http2Connection;
        }
        ConsulConnection cachedConsulConnection = this.connectionPool.get(cacheKey);
        if (cachedConsulConnection == null) {
            cachedConsulConnection = new ConsulConnection();
            this.connectionPool.put(cacheKey, cachedConsulConnection);
        }
        return cachedConsulConnection;
    }

    private class ConsulConnection {
        private ClientConnection connection;
        private AtomicInteger reqCounter = new AtomicInteger(0);

        public ClientConnection getConnection() {
            return this.connection;
        }

        public void setConnection(ClientConnection connection) {
            this.connection = connection;
        }

        public AtomicInteger getReqCounter() {
            return this.reqCounter;
        }

        public void setReqCounter(AtomicInteger reqCounter) {
            this.reqCounter = reqCounter;
        }

        AtomicReference<ClientResponse> send(HttpString method, String path, String token, String json) throws InterruptedException {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            if (this.needsToCreateConnection()) {
                this.connection = this.createConnection();
            }
            ClientRequest request = new ClientRequest().setMethod(method).setPath(path);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            if (token != null) {
                request.getRequestHeaders().put(HttpStringConstants.CONSUL_TOKEN, token);
            }
            logger.debug("The request sent to consul: {} = request header: {}, request body is empty", (Object)ConsulClientImpl.this.uri.toString(), (Object)request.toString());
            if (StringUtils.isBlank((CharSequence)json)) {
                this.connection.sendRequest(request, ConsulClientImpl.this.client.createClientCallback(reference, latch));
            } else {
                request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                this.connection.sendRequest(request, ConsulClientImpl.this.client.createClientCallback(reference, latch, json));
            }
            latch.await();
            this.reqCounter.getAndIncrement();
            logger.debug("The response got from consul: {} = {}", (Object)ConsulClientImpl.this.uri.toString(), (Object)((ClientResponse)reference.get()).toString());
            return reference;
        }

        boolean needsToCreateConnection() {
            return this.connection == null || !this.connection.isOpen() || this.reqCounter.get() >= ConsulClientImpl.this.maxReqPerConn;
        }

        ClientConnection createConnection() {
            logger.debug("connection is closed with counter {}, reconnecting...", (Object)this.reqCounter);
            ClientConnection newConnection = null;
            try {
                newConnection = (ClientConnection)ConsulClientImpl.this.client.connect(ConsulClientImpl.this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, ConsulClientImpl.this.optionMap).get();
            }
            catch (IOException e) {
                logger.error("cannot create connection to consul {} due to: {}", (Object)ConsulClientImpl.this.uri, (Object)e.getMessage());
            }
            this.reqCounter.set(0);
            return newConnection;
        }
    }
}

