/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.config.Config;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConfig {
    public static final String CONFIG_NAME = "consul";
    private static final Logger logger = LoggerFactory.getLogger(ConsulConfig.class);
    private static final String CONSUL_URL = "consulUrl";
    private static final String CONSUL_TOKEN = "consulToken";
    private static final String MAX_REQ_PER_CONN = "maxReqPerConn";
    private static final String CHECK_INTERVAL = "checkInterval";
    private static final String TCP_CHECK = "tcpCheck";
    private static final String HTTP_CHECK = "httpCheck";
    private static final String TTL_CHECK = "ttlCheck";
    private static final String WAIT = "wait";
    private static final String TIMEOUT_BUFFER = "timeoutBuffer";
    private static final String ENABLE_HTTP2 = "enableHttp2";
    private static final String CONNECTION_TIMEOUT = "connectionTimeout";
    private static final String REQUEST_TIMEOUT = "requestTimeout";
    private static final String RECONNECT_INTERVAL = "reconnectInterval";
    private static final String RECONNECT_JITTER = "reconnectJitter";
    private static final String LOOKUP_INTERVAL = "lookupInterval";
    private static final String MAX_ATTEMPTS_BEFORE_SHUTDOWN = "maxAttemptsBeforeShutdown";
    private static final String SHUTDOWN_IF_THREAD_FROZEN = "shutdownIfThreadFrozen";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    String consulUrl;
    String consulToken;
    int maxReqPerConn;
    String deregisterAfter;
    String checkInterval;
    boolean tcpCheck;
    boolean httpCheck;
    boolean ttlCheck;
    boolean enableHttp2;
    String wait = "600s";
    String timeoutBuffer = "5s";
    int connectionTimeout = 5;
    int requestTimeout = 5;
    int reconnectInterval = 2;
    int reconnectJitter = 2;
    int lookupInterval = 15;
    int maxAttemptsBeforeShutdown = -1;
    boolean shutdownIfThreadFrozen = false;

    private ConsulConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private ConsulConfig() {
        this(CONFIG_NAME);
    }

    public static ConsulConfig load(String configName) {
        return new ConsulConfig(configName);
    }

    public static ConsulConfig load() {
        return new ConsulConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public String getConsulUrl() {
        return this.consulUrl;
    }

    public void setConsulUrl(String consulUrl) {
        this.consulUrl = consulUrl;
    }

    public String getConsulToken() {
        return this.consulToken;
    }

    public void setConsulToken(String consulToken) {
        this.consulToken = consulToken;
    }

    public int getMaxReqPerConn() {
        return this.maxReqPerConn;
    }

    public void setMaxReqPerConn(int maxReqPerConn) {
        this.maxReqPerConn = maxReqPerConn;
    }

    public String getDeregisterAfter() {
        return this.deregisterAfter;
    }

    public void setDeregisterAfter(String deregisterAfter) {
        this.deregisterAfter = deregisterAfter;
    }

    public String getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(String checkInterval) {
        this.checkInterval = checkInterval;
    }

    public boolean isTcpCheck() {
        return this.tcpCheck;
    }

    public void setTcpCheck(boolean tcpCheck) {
        this.tcpCheck = tcpCheck;
    }

    public boolean isHttpCheck() {
        return this.httpCheck;
    }

    public void setHttpCheck(boolean httpCheck) {
        this.httpCheck = httpCheck;
    }

    public boolean isTtlCheck() {
        return this.ttlCheck;
    }

    public void setTtlCheck(boolean ttlCheck) {
        this.ttlCheck = ttlCheck;
    }

    public String getWait() {
        return this.wait;
    }

    public void setWait(String wait) {
        this.wait = wait;
    }

    public String getTimeoutBuffer() {
        return this.timeoutBuffer;
    }

    public void setTimeoutBuffer(String timeoutBuffer) {
        this.timeoutBuffer = timeoutBuffer;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void setEnableHttp2(boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public long getReconnectJitter() {
        return this.reconnectJitter;
    }

    public long getLookupInterval() {
        return this.lookupInterval;
    }

    public long getMaxAttemptsBeforeShutdown() {
        return this.maxAttemptsBeforeShutdown;
    }

    public boolean isShutdownIfThreadFrozen() {
        return this.shutdownIfThreadFrozen;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(CONSUL_URL);
        if (object != null) {
            this.consulUrl = (String)object;
        }
        if ((object = this.mappedConfig.get(CONSUL_TOKEN)) != null) {
            this.consulToken = (String)object;
        }
        if ((object = this.mappedConfig.get(MAX_REQ_PER_CONN)) != null) {
            this.maxReqPerConn = Config.loadIntegerValue((String)MAX_REQ_PER_CONN, (Object)object);
        }
        if ((object = this.mappedConfig.get(CHECK_INTERVAL)) != null) {
            this.checkInterval = (String)object;
        }
        if ((object = this.mappedConfig.get(TCP_CHECK)) != null) {
            this.tcpCheck = Config.loadBooleanValue((String)TCP_CHECK, (Object)object);
        }
        if ((object = this.mappedConfig.get(HTTP_CHECK)) != null) {
            this.httpCheck = Config.loadBooleanValue((String)HTTP_CHECK, (Object)object);
        }
        if ((object = this.mappedConfig.get(TTL_CHECK)) != null) {
            this.ttlCheck = Config.loadBooleanValue((String)TTL_CHECK, (Object)object);
        }
        if ((object = this.mappedConfig.get(WAIT)) != null) {
            this.wait = (String)object;
        }
        if ((object = this.mappedConfig.get(TIMEOUT_BUFFER)) != null) {
            this.timeoutBuffer = (String)object;
        }
        if ((object = this.mappedConfig.get(ENABLE_HTTP2)) != null) {
            this.enableHttp2 = Config.loadBooleanValue((String)ENABLE_HTTP2, (Object)object);
        }
        if ((object = this.mappedConfig.get(CONNECTION_TIMEOUT)) != null) {
            this.connectionTimeout = Config.loadIntegerValue((String)CONNECTION_TIMEOUT, (Object)object);
        }
        if ((object = this.mappedConfig.get(REQUEST_TIMEOUT)) != null) {
            this.requestTimeout = Config.loadIntegerValue((String)REQUEST_TIMEOUT, (Object)object);
        }
        if ((object = this.mappedConfig.get(RECONNECT_INTERVAL)) != null) {
            this.reconnectInterval = Config.loadIntegerValue((String)RECONNECT_INTERVAL, (Object)object);
        }
        if ((object = this.mappedConfig.get(RECONNECT_JITTER)) != null) {
            this.reconnectJitter = Config.loadIntegerValue((String)RECONNECT_JITTER, (Object)object);
        }
        if ((object = this.mappedConfig.get(LOOKUP_INTERVAL)) != null) {
            this.lookupInterval = Config.loadIntegerValue((String)LOOKUP_INTERVAL, (Object)object);
        }
        if ((object = this.mappedConfig.get(MAX_ATTEMPTS_BEFORE_SHUTDOWN)) != null) {
            this.maxAttemptsBeforeShutdown = Config.loadIntegerValue((String)MAX_ATTEMPTS_BEFORE_SHUTDOWN, (Object)object);
        }
        if ((object = this.mappedConfig.get(SHUTDOWN_IF_THREAD_FROZEN)) != null) {
            this.shutdownIfThreadFrozen = Config.loadBooleanValue((String)SHUTDOWN_IF_THREAD_FROZEN, (Object)object);
        }
    }
}

