/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.consul.ConsulService;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.registry.URLParamType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConsulUtils {
    public static boolean isSame(List<URL> urls1, List<URL> urls2) {
        if (urls1 == null && urls2 == null) {
            return true;
        }
        if (urls1 == null || urls2 == null) {
            return false;
        }
        if (urls1.size() != urls2.size()) {
            return false;
        }
        return urls1.containsAll(urls2);
    }

    public static ConsulService buildService(URL url) {
        ConsulService service = new ConsulService();
        service.setAddress(url.getHost());
        service.setId(ConsulUtils.convertConsulSerivceId(url));
        service.setName(url.getPath());
        service.setPort(url.getPort());
        ArrayList<String> tags = new ArrayList<String>();
        String env = url.getParameter("environment");
        if (env != null) {
            tags.add(env);
        }
        service.setTags(tags);
        return service;
    }

    public static URL buildUrl(String protocol, ConsulService service) {
        URLImpl url = null;
        if (url == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (!service.getTags().isEmpty()) {
                params.put(URLParamType.environment.getName(), service.getTags().get(0));
            }
            url = new URLImpl(protocol, service.getAddress(), service.getPort().intValue(), ConsulUtils.getPathFromServiceId(service.getId()), params);
        }
        return url;
    }

    public static String getUrlClusterInfo(URL url) {
        return url.getPath();
    }

    public static String convertGroupToServiceName(String group) {
        return group;
    }

    public static String getGroupFromServiceName(String group) {
        return group;
    }

    public static String convertConsulSerivceId(URL url) {
        if (url == null) {
            return null;
        }
        return ConsulUtils.convertServiceId(url.getHost(), url.getPort(), url.getPath());
    }

    public static String getPathFromServiceId(String serviceId) {
        return serviceId.substring(serviceId.indexOf(":") + 1, serviceId.lastIndexOf(":"));
    }

    public static String getProtocolFromTag(String tag) {
        return tag.substring("protocol_".length());
    }

    public static String convertServiceId(String host, int port, String path) {
        return host + ":" + path + ":" + port;
    }

    public static int getWaitInSecond(String wait) {
        int w = 600;
        if (wait.endsWith("s")) {
            w = Integer.valueOf(wait.substring(0, wait.length() - 1));
        } else if (wait.endsWith("m")) {
            w = Integer.valueOf(wait.substring(0, wait.length() - 1)) * 60;
        }
        return w;
    }

    public static int getTimeoutBufferInSecond(String timeoutBuffer) {
        int w = 5;
        if (timeoutBuffer.endsWith("s")) {
            w = Integer.valueOf(timeoutBuffer.substring(0, timeoutBuffer.length() - 1));
        } else if (timeoutBuffer.endsWith("m")) {
            w = Integer.valueOf(timeoutBuffer.substring(0, timeoutBuffer.length() - 1)) * 60;
        }
        return w;
    }
}

