/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.dump.AbstractDumper;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.IRequestDumpable;
import com.networknt.dump.IResponseDumpable;
import com.networknt.mask.Mask;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CookiesDumper
extends AbstractDumper
implements IRequestDumpable,
IResponseDumpable {
    private Map<String, Object> cookieMap = new LinkedHashMap<String, Object>();

    CookiesDumper(DumpConfig config, HttpServerExchange exchange) {
        super(config, exchange);
    }

    @Override
    public void dumpRequest(Map<String, Object> result) {
        Map cookiesMap = this.exchange.getRequestCookies();
        this.dumpCookies(cookiesMap, "requestCookies");
        this.putDumpInfoTo(result);
    }

    @Override
    public void dumpResponse(Map<String, Object> result) {
        Map cookiesMap = this.exchange.getResponseCookies();
        this.dumpCookies(cookiesMap, "responseCookies");
        this.putDumpInfoTo(result);
    }

    private void dumpCookies(Map<String, Cookie> cookiesMap, String maskKey) {
        cookiesMap.forEach((key, cookie) -> {
            if (!this.config.getRequestFilteredCookies().contains(cookie.getName())) {
                ArrayList<HashMap> cookieInfoList = new ArrayList<HashMap>();
                final String cookieValue = this.config.isMaskEnabled() ? Mask.maskRegex((String)cookie.getValue(), (String)maskKey, (String)cookie.getName()) : cookie.getValue();
                cookieInfoList.add(new HashMap<String, String>(){
                    {
                        this.put("value", cookieValue);
                    }
                });
                cookieInfoList.add(new HashMap<String, String>(){
                    {
                        this.put("domain", cookie.getDomain());
                    }
                });
                cookieInfoList.add(new HashMap<String, String>(){
                    {
                        this.put("path", cookie.getPath());
                    }
                });
                cookieInfoList.add(new HashMap<String, String>(){
                    {
                        this.put("expires", cookie.getExpires() == null ? "" : cookie.getExpires().toString());
                    }
                });
                this.cookieMap.put((String)key, cookieInfoList);
            }
        });
    }

    @Override
    protected void putDumpInfoTo(Map<String, Object> result) {
        if (this.cookieMap.size() > 0) {
            result.put("cookies", this.cookieMap);
        }
    }

    @Override
    public boolean isApplicableForRequest() {
        return this.config.isRequestCookieEnabled();
    }

    @Override
    public boolean isApplicableForResponse() {
        return this.config.isResponseCookieEnabled();
    }
}

