/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.config.Config;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.DumpHelper;
import com.networknt.dump.RootDumper;
import com.networknt.dump.StoreResponseStreamSinkConduit;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xnio.conduits.StreamSinkConduit;

public class DumpHandler
implements MiddlewareHandler {
    private static final String CONFIG_NAME = "dump";
    private static DumpConfig config = (DumpConfig)Config.getInstance().getJsonObjectConfig("dump", DumpConfig.class);
    private volatile HttpHandler next;

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)DumpHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        if (this.isEnabled()) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            RootDumper rootDumper = new RootDumper(config, exchange);
            rootDumper.dumpRequest(result);
            if (config.isResponseEnabled()) {
                exchange.addResponseWrapper((factory, exchange12) -> new StoreResponseStreamSinkConduit((StreamSinkConduit)factory.create(), exchange12));
            }
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                rootDumper.dumpResponse(result);
                DumpHelper.logResult(result, config);
                nextListener.proceed();
            });
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }
}

