/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.dump.AbstractDumper;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.IRequestDumpable;
import com.networknt.dump.IResponseDumpable;
import com.networknt.mask.Mask;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class HeadersDumper
extends AbstractDumper
implements IRequestDumpable,
IResponseDumpable {
    private Map<String, Object> headerMap = new LinkedHashMap<String, Object>();

    public HeadersDumper(DumpConfig config, HttpServerExchange exchange) {
        super(config, exchange);
    }

    @Override
    protected void putDumpInfoTo(Map<String, Object> result) {
        if (this.headerMap.size() > 0) {
            result.put("headers", this.headerMap);
        }
    }

    @Override
    public void dumpRequest(Map<String, Object> result) {
        HeaderMap headers = this.exchange.getRequestHeaders();
        this.dumpHeaders(headers);
        if (this.config.isMaskEnabled()) {
            this.headerMap.forEach((s, o) -> this.headerMap.put((String)s, Mask.maskRegex((String)((String)o), (String)"requestHeader", (String)s)));
        }
        this.putDumpInfoTo(result);
    }

    @Override
    public void dumpResponse(Map<String, Object> result) {
        HeaderMap headers = this.exchange.getResponseHeaders();
        this.dumpHeaders(headers);
        if (this.config.isMaskEnabled()) {
            this.headerMap.forEach((s, o) -> this.headerMap.put((String)s, Mask.maskRegex((String)((String)o), (String)"responseHeader", (String)s)));
        }
        this.putDumpInfoTo(result);
    }

    private void dumpHeaders(HeaderMap headers) {
        headers.forEach(headerValues -> headerValues.forEach(headerValue -> {
            String headerName = headerValues.getHeaderName().toString();
            if (!this.config.getRequestFilteredHeaders().contains(headerName)) {
                this.headerMap.put(headerName, headerValue);
            }
        }));
    }

    @Override
    public boolean isApplicableForRequest() {
        return this.config.isRequestHeaderEnabled();
    }

    @Override
    public boolean isApplicableForResponse() {
        return this.config.isResponseHeaderEnabled();
    }
}

