/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public class StoreResponseStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    public static final AttachmentKey<byte[]> RESPONSE = AttachmentKey.create(byte[].class);
    private ByteArrayOutputStream outputStream;
    private final HttpServerExchange exchange;

    public StoreResponseStreamSinkConduit(StreamSinkConduit next, HttpServerExchange exchange) {
        super(next);
        this.exchange = exchange;
        long length = exchange.getResponseContentLength();
        if (length <= 0L) {
            this.outputStream = new ByteArrayOutputStream();
        } else {
            if (length > Integer.MAX_VALUE) {
                throw UndertowMessages.MESSAGES.responseTooLargeToBuffer(Long.valueOf(length));
            }
            this.outputStream = new ByteArrayOutputStream((int)length);
        }
    }

    public int write(ByteBuffer src) throws IOException {
        int start = src.position();
        int ret = super.write(src);
        for (int i = start; i < start + ret; ++i) {
            this.outputStream.write(src.get(i));
        }
        return ret;
    }

    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long ret;
        int[] starts = new int[len];
        for (int i = 0; i < len; ++i) {
            starts[i] = srcs[i + offs].position();
        }
        long rem = ret = super.write(srcs, offs, len);
        for (int i = 0; i < len; ++i) {
            ByteBuffer buf = srcs[i + offs];
            int limit = buf.limit();
            for (int pos = starts[i]; rem > 0L && pos <= buf.position() && pos < limit; ++pos, --rem) {
                this.outputStream.write(buf.get(pos));
            }
        }
        return ret;
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        int start = src.position();
        int ret = super.writeFinal(src);
        for (int i = start; i < start + ret; ++i) {
            this.outputStream.write(src.get(i));
        }
        return ret;
    }

    public long writeFinal(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long ret;
        int[] starts = new int[len];
        long toWrite = 0L;
        for (int i = 0; i < len; ++i) {
            starts[i] = srcs[i + offs].position();
            toWrite += (long)srcs[i + offs].remaining();
        }
        long rem = ret = super.write(srcs, offs, len);
        for (int i = 0; i < len; ++i) {
            ByteBuffer buf = srcs[i + offs];
            int limit = buf.limit();
            for (int pos = starts[i]; rem > 0L && pos <= buf.position() && pos < limit; ++pos, --rem) {
                this.outputStream.write(buf.get(pos));
            }
        }
        return ret;
    }

    public void terminateWrites() throws IOException {
        this.exchange.putAttachment(RESPONSE, (Object)this.outputStream.toByteArray());
        this.outputStream = null;
        super.terminateWrites();
    }
}

