/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.dump.AbstractDumper;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.IRequestDumpable;
import com.networknt.mask.Mask;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.util.Map;

public class UrlDumper
extends AbstractDumper
implements IRequestDumpable {
    private String url = "";

    public UrlDumper(DumpConfig config, HttpServerExchange exchange) {
        super(config, exchange);
    }

    @Override
    public void dumpRequest(Map<String, Object> result) {
        this.url = this.exchange.getRequestURL();
        if (this.config.isMaskEnabled()) {
            Mask.maskString((String)this.url, (String)"uri");
        }
        this.putDumpInfoTo(result);
    }

    @Override
    protected void putDumpInfoTo(Map<String, Object> result) {
        if (StringUtils.isNotBlank((CharSequence)this.url)) {
            result.put("url", this.url);
        }
    }

    @Override
    public boolean isApplicableForRequest() {
        return this.config.isRequestUrlEnabled();
    }
}

