/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.status.Status;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LightHttpHandler
extends HttpHandler {
    public static final Logger logger = LoggerFactory.getLogger(LightHttpHandler.class);
    public static final String ERROR_NOT_DEFINED = "ERR10042";

    default public void setExchangeStatus(HttpServerExchange exchange, String code, Object ... args) {
        Status status = new Status(code, args);
        if (status.getStatusCode() == 0) {
            status = new Status(ERROR_NOT_DEFINED, new Object[]{code});
        }
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        status.setDescription(status.getDescription().replaceAll("\\\\", "\\\\\\\\"));
        exchange.getResponseSender().send(status.toString());
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        logger.error(status.toString() + " at " + elements[2].getClassName() + "." + elements[2].getMethodName() + "(" + elements[2].getFileName() + ":" + elements[2].getLineNumber() + ")");
    }
}

