/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.config;

import com.networknt.utility.NetUtils;
import java.util.ArrayList;
import java.util.List;

public class PathChain {
    private String source;
    private String path;
    private String method;
    private List<String> exec;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<String> getExec() {
        return this.exec;
    }

    public void setExec(List<String> exec) {
        this.exec = exec;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String toString() {
        if (this.path != null) {
            return this.path + "@" + this.method + " \u2192 " + this.exec;
        }
        return this.source + "() \u2192 " + this.exec;
    }

    public void validate(String origin) {
        ArrayList<String> problems = new ArrayList<String>();
        if (this.source == null) {
            if (this.path == null) {
                problems.add("You must specify either path or source");
            } else if (this.method == null) {
                problems.add("You must specify method along with path: " + this.path);
            }
        } else {
            if (this.path != null) {
                problems.add("Conflicting source: " + this.source + " and path: " + this.path);
            }
            if (this.method != null) {
                problems.add("Conflicting source: " + this.source + " and method: " + this.method);
            }
        }
        if (this.method != null && !NetUtils.METHODS.contains(this.method.toUpperCase())) {
            problems.add("Invalid HTTP method: " + this.method);
        }
        if (!problems.isEmpty()) {
            throw new RuntimeException("Bad paths element in " + origin + " [ " + String.join((CharSequence)" | ", problems) + " ]");
        }
    }
}

