/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.util;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;

public interface RedirectSenders {
    default public void temporary(HttpServerExchange exchange, String location) {
        exchange.setStatusCode(302);
        exchange.getResponseHeaders().put(Headers.LOCATION, location);
        exchange.endExchange();
    }

    default public void permanent(HttpServerExchange exchange, String location) {
        exchange.setStatusCode(301);
        exchange.getResponseHeaders().put(Headers.LOCATION, location);
        exchange.endExchange();
    }

    default public void referer(HttpServerExchange exchange) {
        exchange.setStatusCode(302);
        exchange.getResponseHeaders().put(Headers.LOCATION, exchange.getRequestHeaders().get(Headers.REFERER, 0));
        exchange.endExchange();
    }
}

