/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.health;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.handler.LightHttpHandler;
import com.networknt.health.HealthConfig;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthGetHandler
implements LightHttpHandler {
    public static final String CONFIG_NAME = "health";
    public static final String HEALTH_RESULT_OK = "OK";
    public static final String HEALTH_RESULT_OK_JSON = JsonMapper.toJson((Object)new HealthResult("OK"));
    static final Logger logger = LoggerFactory.getLogger(HealthGetHandler.class);
    static final HealthConfig config = (HealthConfig)Config.getInstance().getJsonObjectConfig("health", HealthConfig.class);

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (config != null && config.isUseJson()) {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(HEALTH_RESULT_OK_JSON);
        } else {
            exchange.getResponseSender().send(HEALTH_RESULT_OK);
        }
    }

    static class HealthResult {
        private String result;

        private HealthResult(String result) {
            this.setResult(result);
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }
}

