/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.config.Config;
import com.networknt.status.Status;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsRequest
extends TokenRequest {
    private static final Logger logger = LoggerFactory.getLogger(ClientCredentialsRequest.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";

    public ClientCredentialsRequest() {
        this(null);
    }

    public ClientCredentialsRequest(Map<String, Object> ccConfig) {
        this.setGrantType("client_credentials");
        Map tokenConfig = ClientConfig.get().getTokenConfig();
        if (tokenConfig != null) {
            this.setServerUrl((String)tokenConfig.get("server_url"));
            this.setProxyHost((String)tokenConfig.get("proxyHost"));
            int port = tokenConfig.get("proxyPort") == null ? 443 : Config.loadIntegerValue((String)"proxyPort", tokenConfig.get("proxyPort"));
            this.setProxyPort(port);
            this.setServiceId((String)tokenConfig.get("serviceId"));
            Object object = tokenConfig.get("enableHttp2");
            if (object != null) {
                this.setEnableHttp2(Config.loadBooleanValue((String)"enableHttp2", object));
            }
            if (ccConfig == null) {
                ccConfig = (Map)tokenConfig.get("client_credentials");
            }
            if (ccConfig != null) {
                this.setClientId((String)ccConfig.get("client_id"));
                if (ccConfig.get("client_secret") != null) {
                    this.setClientSecret((String)ccConfig.get("client_secret"));
                } else {
                    logger.error(new Status(CONFIG_PROPERTY_MISSING, new Object[]{"client_credentials client_secret", "client.yml"}).toString());
                }
                this.setUri((String)ccConfig.get("uri"));
                this.setScope(this.loadScope(ccConfig));
                if (ccConfig.get("server_url") != null) {
                    this.setServerUrl((String)ccConfig.get("server_url"));
                }
                if (ccConfig.get("serviceId") != null) {
                    this.setServiceId((String)ccConfig.get("serviceId"));
                }
                if (ccConfig.get("proxyHost") != null) {
                    String proxyHost = (String)ccConfig.get("proxyHost");
                    if (proxyHost.length() > 1) {
                        this.setProxyHost((String)ccConfig.get("proxyHost"));
                        port = ccConfig.get("proxyPort") == null ? 443 : Config.loadIntegerValue((String)"proxyPort", ccConfig.get("proxyPort"));
                        this.setProxyPort(port);
                    } else {
                        this.setProxyHost(null);
                        this.setProxyPort(0);
                    }
                }
                if (ccConfig.get("enableHttp2") != null && (object = ccConfig.get("enableHttp2")) != null) {
                    this.setEnableHttp2(Config.loadBooleanValue((String)"enableHttp2", object));
                }
            }
        }
    }
}

