/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.KeyRequest;
import com.networknt.config.Config;
import com.networknt.status.Status;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenKeyRequest
extends KeyRequest {
    private static final Logger logger = LoggerFactory.getLogger(TokenKeyRequest.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    private boolean jwk;

    public TokenKeyRequest(String kid) {
        this(kid, false, null);
    }

    public TokenKeyRequest(String kid, boolean jwk, Map<String, Object> keyConfig) {
        super(kid);
        this.jwk = jwk;
        Map clientConfig = ClientConfig.get().getMappedConfig();
        if (clientConfig != null) {
            Map oauthConfig = (Map)clientConfig.get("oauth");
            if (oauthConfig != null) {
                Map tokenConfig = ClientConfig.get().getTokenConfig();
                if (tokenConfig != null) {
                    this.setProxyHost((String)tokenConfig.get("proxyHost"));
                    int port = tokenConfig.get("proxyPort") == null ? 443 : Config.loadIntegerValue((String)"proxyPort", tokenConfig.get("proxyPort"));
                    this.setProxyPort(port);
                    if (keyConfig == null) {
                        keyConfig = (Map)tokenConfig.get("key");
                    }
                    if (keyConfig != null) {
                        this.setKeyOptions(keyConfig);
                    } else {
                        logger.error(new Status(CONFIG_PROPERTY_MISSING, new Object[]{"token section", "client.yml"}).toString());
                    }
                } else {
                    logger.error(new Status(CONFIG_PROPERTY_MISSING, new Object[]{"token section", "client.yml"}).toString());
                }
            } else {
                logger.error(new Status(CONFIG_PROPERTY_MISSING, new Object[]{"oauth section", "client.yml"}).toString());
            }
        } else {
            logger.error(new Status(CONFIG_PROPERTY_MISSING, new Object[]{"oauth key section", "client.yml"}).toString());
        }
    }

    private void setKeyOptions(Map<String, Object> keyConfig) {
        this.setServerUrl((String)keyConfig.get("server_url"));
        this.setServiceId((String)keyConfig.get("serviceId"));
        Object object = keyConfig.get("enableHttp2");
        if (object != null) {
            this.setEnableHttp2(Config.loadBooleanValue((String)"enableHttp2", (Object)object));
        }
        if (this.jwk) {
            this.setUri(keyConfig.get("uri").toString());
        } else {
            this.setUri(keyConfig.get("uri") + "/" + this.kid);
        }
        if (keyConfig.get("client_id") != null) {
            this.setClientId((String)keyConfig.get("client_id"));
        }
        if (keyConfig.get("client_secret") != null) {
            this.setClientSecret((String)keyConfig.get("client_secret"));
        }
        if (keyConfig.get("audience") != null) {
            this.setAudience((String)keyConfig.get("audience"));
        }
        if (keyConfig.get("proxyHost") != null) {
            String proxyHost = (String)keyConfig.get("proxyHost");
            if (proxyHost.length() > 1) {
                this.setProxyHost(proxyHost);
                int port = keyConfig.get("proxyPort") == null ? 443 : Config.loadIntegerValue((String)"proxyPort", (Object)keyConfig.get("proxyPort"));
                this.setProxyPort(port);
            } else {
                this.setProxyHost(null);
                this.setProxyPort(0);
            }
        }
    }
}

