/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.config.Config;
import com.networknt.status.Status;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerefRequest {
    private static final Logger logger = LoggerFactory.getLogger(DerefRequest.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    private String serverUrl;
    private String proxyHost;
    private int proxyPort;
    private String serviceId;
    private String uri;
    private String clientId;
    private String clientSecret;
    private boolean enableHttp2;

    public DerefRequest(String token) {
        Map derefConfig = ClientConfig.get().getDerefConfig();
        if (derefConfig != null) {
            this.setServerUrl((String)derefConfig.get("server_url"));
            this.setProxyHost((String)derefConfig.get("proxyHost"));
            int port = derefConfig.get("proxyPort") == null ? 443 : Config.loadIntegerValue((String)"proxyPort", derefConfig.get("proxyPort"));
            this.setProxyPort(port);
            this.setServiceId((String)derefConfig.get("serviceId"));
            Object object = derefConfig.get("enableHttp2");
            if (object != null) {
                this.setEnableHttp2(Config.loadBooleanValue((String)"enableHttp2", object));
            }
            this.setUri(derefConfig.get("uri") + "/" + token);
            this.setClientId((String)derefConfig.get("client_id"));
            if (derefConfig.get("client_secret") != null) {
                this.setClientSecret((String)derefConfig.get("client_secret"));
            } else {
                logger.error(new Status(CONFIG_PROPERTY_MISSING, new Object[]{"deref client_secret", "client.yml"}).toString());
            }
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void setEnableHttp2(boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }
}

