/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.config.Config;
import com.networknt.utility.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Jwt {
    protected Set<String> scopes = new HashSet<String>();
    protected Key key;
    protected Map<String, Object> ccConfig;
    private String jwt;
    private long expire;
    private volatile boolean renewing = false;
    private volatile long expiredRetryTimeout;
    private volatile long earlyRetryTimeout;
    private static long tokenRenewBeforeExpired;
    private static long expiredRefreshRetryDelay;
    private static long earlyRefreshRetryDelay;

    public Jwt() {
        Map tokenConfig = ClientConfig.get().getTokenConfig();
        if (tokenConfig != null) {
            Object object = tokenConfig.get("tokenRenewBeforeExpired");
            if (object != null) {
                tokenRenewBeforeExpired = Config.loadLongValue((String)"tokenRenewBeforeExpired", object);
            }
            if ((object = tokenConfig.get("expiredRefreshRetryDelay")) != null) {
                expiredRefreshRetryDelay = Config.loadLongValue((String)"expiredRefreshRetryDelay", object);
            }
            if ((object = tokenConfig.get("earlyRefreshRetryDelay")) != null) {
                earlyRefreshRetryDelay = Config.loadLongValue((String)"earlyRefreshRetryDelay", object);
            }
        }
    }

    public Jwt(Key key) {
        this();
        this.key = key;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public boolean isRenewing() {
        return this.renewing;
    }

    public void setRenewing(boolean renewing) {
        this.renewing = renewing;
    }

    public long getExpiredRetryTimeout() {
        return this.expiredRetryTimeout;
    }

    public void setExpiredRetryTimeout(long expiredRetryTimeout) {
        this.expiredRetryTimeout = expiredRetryTimeout;
    }

    public long getEarlyRetryTimeout() {
        return this.earlyRetryTimeout;
    }

    public void setEarlyRetryTimeout(long earlyRetryTimeout) {
        this.earlyRetryTimeout = earlyRetryTimeout;
    }

    public static long getTokenRenewBeforeExpired() {
        return tokenRenewBeforeExpired;
    }

    public static void setTokenRenewBeforeExpired(long tokenRenewBeforeExpired) {
        Jwt.tokenRenewBeforeExpired = tokenRenewBeforeExpired;
    }

    public static long getExpiredRefreshRetryDelay() {
        return expiredRefreshRetryDelay;
    }

    public static void setExpiredRefreshRetryDelay(long expiredRefreshRetryDelay) {
        Jwt.expiredRefreshRetryDelay = expiredRefreshRetryDelay;
    }

    public static long getEarlyRefreshRetryDelay() {
        return earlyRefreshRetryDelay;
    }

    public static void setEarlyRefreshRetryDelay(long earlyRefreshRetryDelay) {
        Jwt.earlyRefreshRetryDelay = earlyRefreshRetryDelay;
    }

    public Map<String, Object> getCcConfig() {
        return this.ccConfig;
    }

    public void setCcConfig(Map<String, Object> ccConfig) {
        this.ccConfig = ccConfig;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public void setScopes(String scopesStr) {
        Set<Object> set = this.scopes = this.scopes == null ? new HashSet() : this.scopes;
        if (StringUtils.isNotBlank((CharSequence)scopesStr)) {
            this.scopes.addAll(Arrays.asList(scopesStr.split("(\\s)+")));
        }
    }

    public Key getKey() {
        return this.key;
    }

    public static class Key {
        protected Set<String> scopes;
        protected String serviceId;

        public int hashCode() {
            return Objects.hash(this.scopes, this.serviceId);
        }

        public boolean equals(Object obj) {
            return this.hashCode() == obj.hashCode();
        }

        public Key(Set<String> scopes) {
            this.scopes = scopes;
        }

        public Key(String serviceId) {
            this.serviceId = serviceId;
        }

        public Key() {
            this.scopes = new HashSet<String>();
        }

        public Set<String> getScopes() {
            return this.scopes;
        }

        public String getServiceId() {
            return this.serviceId;
        }
    }
}

