/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.cache.ICacheStrategy;
import com.networknt.client.oauth.cache.LongestExpireCacheStrategy;
import com.networknt.config.Config;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.status.Status;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager {
    private static final Logger logger = LoggerFactory.getLogger(TokenManager.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    private static volatile TokenManager INSTANCE;
    private static int CAPACITY;
    private ICacheStrategy cacheStrategy;

    private TokenManager() {
        Map cacheConfig;
        Map tokenConfig = ClientConfig.get().getTokenConfig();
        if (tokenConfig != null && (cacheConfig = (Map)tokenConfig.get("cache")) != null && cacheConfig.get("capacity") != null) {
            CAPACITY = Config.loadIntegerValue((String)"capacity", cacheConfig.get("capacity"));
        }
        this.cacheStrategy = new LongestExpireCacheStrategy(CAPACITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TokenManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TokenManager> clazz = TokenManager.class;
        synchronized (TokenManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TokenManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Result<Jwt> getJwt(Jwt.Key key, Map<String, Object> ccConfig) {
        Result<Jwt> result;
        Jwt cachedJwt = this.getJwt(this.cacheStrategy, key);
        if (ccConfig != null) {
            cachedJwt.setCcConfig(ccConfig);
        }
        if ((result = OauthHelper.populateCCToken(cachedJwt)).isSuccess()) {
            this.cacheStrategy.cacheJwt(key, (Jwt)result.getResult());
        }
        return result;
    }

    private synchronized Jwt getJwt(ICacheStrategy cacheStrategy, Jwt.Key key) {
        Jwt result = cacheStrategy.getCachedJwt(key);
        if (result == null) {
            result = new Jwt(key);
            cacheStrategy.cacheJwt(key, result);
        }
        return result;
    }

    public Result<Jwt> getJwt(String requestPath, String scopes, String serviceId) {
        if (ClientConfig.get().isMultipleAuthServers()) {
            Map clientCredentials;
            Map serviceIdAuthServers;
            if (logger.isTraceEnabled()) {
                logger.trace("requestPath = " + requestPath + " scopes = " + scopes + " serviceId = " + serviceId);
            }
            Map pathPrefixServices = ClientConfig.get().getPathPrefixServices();
            for (Map.Entry entry : pathPrefixServices.entrySet()) {
                if (!requestPath.startsWith((String)entry.getKey())) continue;
                serviceId = (String)entry.getValue();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("serviceId = " + serviceId);
            }
            if ((serviceIdAuthServers = (Map)(clientCredentials = (Map)ClientConfig.get().getTokenConfig().get("client_credentials")).get("serviceIdAuthServers")) == null) {
                Status status = new Status(CONFIG_PROPERTY_MISSING, new Object[]{"serviceIdAuthServers", "client.yml"});
                return Failure.of((Status)status);
            }
            Map ccConfig = (Map)serviceIdAuthServers.get(serviceId);
            return this.getJwt(new Jwt.Key(serviceId), ccConfig);
        }
        if (scopes != null) {
            HashSet<String> scopeSet = new HashSet<String>();
            scopeSet.addAll(Arrays.asList(scopes.split(" ")));
            return this.getJwt(new Jwt.Key(scopeSet), null);
        }
        if (serviceId != null) {
            return this.getJwt(new Jwt.Key(serviceId), null);
        }
        return this.getJwt(new Jwt.Key(), null);
    }

    static {
        CAPACITY = 200;
    }
}

