/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.info;

import com.networknt.config.Config;
import com.networknt.utility.ModuleRegistry;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoHandler
implements HttpHandler {
    public static final String CONFIG_NAME = "info";
    public static final String ENABLE_SERVER_INFO = "enableServerInfo";
    static final Logger logger = LoggerFactory.getLogger(ServerInfoHandler.class);

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        LinkedHashMap<String, Object> infoMap = new LinkedHashMap<String, Object>();
        infoMap.put("environment", this.getEnvironment(exchange));
        infoMap.put("specification", Config.getInstance().getJsonMapConfigNoCache("swagger"));
        infoMap.put("component", ModuleRegistry.getRegistry());
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(infoMap));
    }

    public Map<String, Object> getEnvironment(HttpServerExchange exchange) {
        LinkedHashMap<String, Object> envMap = new LinkedHashMap<String, Object>();
        envMap.put("host", this.getHost(exchange));
        envMap.put("runtime", this.getRuntime());
        envMap.put("system", this.getSystem());
        return envMap;
    }

    public Map<String, Object> getHost(HttpServerExchange exchange) {
        LinkedHashMap<String, Object> hostMap = new LinkedHashMap<String, Object>();
        String ip = "unknown";
        String hostname = "unknown";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ip = inetAddress.getHostAddress();
            hostname = inetAddress.getHostName();
        }
        catch (IOException ioe) {
            logger.error("Error in getting IP Address and Hostname", (Throwable)ioe);
        }
        hostMap.put("ip", ip);
        hostMap.put("hostname", hostname);
        hostMap.put("dns", exchange.getSourceAddress().getHostName());
        return hostMap;
    }

    public Map<String, Object> getRuntime() {
        LinkedHashMap<String, Object> runtimeMap = new LinkedHashMap<String, Object>();
        Runtime runtime = Runtime.getRuntime();
        runtimeMap.put("availableProcessors", runtime.availableProcessors());
        runtimeMap.put("freeMemory", runtime.freeMemory());
        runtimeMap.put("totalMemory", runtime.totalMemory());
        runtimeMap.put("maxMemory", runtime.maxMemory());
        return runtimeMap;
    }

    public Map<String, Object> getSystem() {
        LinkedHashMap<String, Object> systemMap = new LinkedHashMap<String, Object>();
        Properties properties = System.getProperties();
        systemMap.put("javaVendor", properties.getProperty("java.vendor"));
        systemMap.put("javaVersion", properties.getProperty("java.version"));
        systemMap.put("osName", properties.getProperty("os.name"));
        systemMap.put("osVersion", properties.getProperty("os.version"));
        systemMap.put("userTimezone", properties.getProperty("user.timezone"));
        return systemMap;
    }
}

