/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.javadoc.plugin.packagelist;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaPackage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="gen-package-list")
public class GenPackageList
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String sourceDir = this.mavenProject.getModel().getBuild().getSourceDirectory();
        String targetDir = this.mavenProject.getModel().getBuild().getDirectory();
        if (this.mavenProject.getModel().getParent() != null) {
            try {
                JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
                javaProjectBuilder.addSourceTree(new File(sourceDir));
                Collection packages = javaProjectBuilder.getPackages();
                if (packages != null && packages.size() > 0) {
                    ArrayList<String> packageNames = new ArrayList<String>();
                    for (JavaPackage javaPackage : packages) {
                        packageNames.add(javaPackage.getName());
                    }
                    new File(targetDir.concat("/apidocs")).mkdirs();
                    FileUtils.fileWrite((String)targetDir.concat("/apidocs/package-list"), (String)String.join((CharSequence)"\n", packageNames));
                    this.getLog().info((CharSequence)"Created package-list");
                } else {
                    this.getLog().info((CharSequence)"Skipping package-list since no packages were found.");
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Failed to generate package-list, as a result javadoc links may not work..");
            }
        }
    }
}

