/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.ListOverlay;
import com.networknt.jsonoverlay.MapOverlay;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.SerializationOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public abstract class PropertiesOverlay<V>
extends JsonOverlay<V> {
    private Map<String, JsonOverlay<?>> children = new HashMap();
    private List<PropertyLocator> childOrder = new CopyOnWriteArrayList<PropertyLocator>();
    private boolean elaborated = false;
    private boolean deferElaboration = false;
    private V elaborationValue = null;

    protected PropertiesOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
        this.deferElaboration = json.isMissingNode();
    }

    protected PropertiesOverlay(V value, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceManager refMgr) {
        super(value, parent, factory, refMgr);
        this.elaborationValue = value;
    }

    protected <T> T _get(String name, Class<T> cls) {
        return this._get(name, true, cls);
    }

    List<String> _getPropertyNames() {
        return this.childOrder.stream().map(locator -> locator.getName()).collect(Collectors.toList());
    }

    <T> JsonOverlay<?> _getOverlay(String name) {
        return this.children.get(name);
    }

    protected boolean _isPresent(String name) {
        JsonOverlay<?> overlay = this.children.get(name);
        return overlay != null && !overlay.json.isMissingNode();
    }

    protected <T> T _get(String name, boolean elaborate, Class<T> cls) {
        if (elaborate) {
            this._ensureElaborated();
        }
        JsonOverlay<?> overlay = this.children.get(name);
        return (T)overlay._get();
    }

    protected <T> JsonOverlay<T> _getOverlay(String name, Class<T> cls) {
        JsonOverlay<?> overlay = this.children.get(name);
        return overlay;
    }

    protected <T> void _setScalar(String name, T val, Class<T> cls) {
        JsonOverlay<?> overlay = this.children.get(name);
        overlay._set(val);
    }

    protected <T> List<T> _getList(String name, Class<T> cls) {
        List list = this._get(name, List.class);
        return list;
    }

    protected <T> List<T> _getList(String name, boolean elaborate, Class<T> cls) {
        List list = this._get(name, elaborate, List.class);
        return list;
    }

    protected <T> T _get(String name, int index, Class<T> cls) {
        return this._get(name, index, true, cls);
    }

    protected <T> T _get(String name, int index, boolean elaborate, Class<T> cls) {
        ListOverlay overlay = (ListOverlay)this.children.get(name);
        return (T)overlay.get(index);
    }

    protected <T> void _setList(String name, List<T> listVal, Class<T> cls) {
        ListOverlay overlay = (ListOverlay)this.children.get(name);
        overlay._set(listVal);
    }

    protected <T> void _set(String name, int index, T val, Class<T> cls) {
        ListOverlay overlay = (ListOverlay)this.children.get(name);
        overlay.set(index, val);
    }

    protected <T> void _insert(String name, int index, T val, Class<T> cls) {
        ListOverlay overlay = (ListOverlay)this.children.get(name);
        overlay.insert(index, val);
    }

    protected <T> void _add(String name, T val, Class<T> cls) {
        ListOverlay overlay = (ListOverlay)this.children.get(name);
        overlay.add(val);
    }

    protected <T> void _remove(String name, int index, Class<T> cls) {
        ListOverlay overlay = (ListOverlay)this.children.get(name);
        overlay.remove(index);
    }

    protected <T> Map<String, T> _getMap(String name, Class<T> cls) {
        Map map = this._get(name, Map.class);
        return map;
    }

    protected <T> Map<String, T> _getMap(String name, boolean elaborate, Class<T> cls) {
        Map map = this._get(name, elaborate, Map.class);
        return map;
    }

    protected <T> T _get(String name, String key, Class<T> cls) {
        return this._get(name, key, true, cls);
    }

    protected <T> T _get(String name, String key, boolean elaborate, Class<T> cls) {
        MapOverlay overlay = (MapOverlay)this.children.get(name);
        return (T)overlay.get(key);
    }

    protected <T> void _setMap(String name, Map<String, T> mapVal, Class<T> cls) {
        MapOverlay overlay = (MapOverlay)this.children.get(name);
        overlay._set(mapVal);
    }

    protected <T> void _set(String name, String key, T val, Class<T> cls) {
        MapOverlay overlay = (MapOverlay)this.children.get(name);
        overlay.set(key, val);
    }

    protected <T> void _remove(String name, String key, Class<T> cls) {
        MapOverlay overlay = (MapOverlay)this.children.get(name);
        overlay.remove(key);
    }

    @Override
    protected void _elaborate(boolean atCreation) {
        if (atCreation && this.deferElaboration) {
            return;
        }
        if (this.elaborationValue != null) {
            this._elaborateValue();
        } else {
            this._elaborateJson();
        }
        Collections.sort(this.childOrder);
        this.elaborated = true;
    }

    protected void _elaborateJson() {
    }

    private void _elaborateValue() {
        PropertiesOverlay overlay = (PropertiesOverlay)this.elaborationValue;
        this.children.clear();
        for (Map.Entry<String, JsonOverlay<?>> entry : overlay.children.entrySet()) {
            this.children.put(entry.getKey(), entry.getValue()._copy());
        }
        this.childOrder.clear();
        this.childOrder.addAll(overlay.childOrder);
        this.elaborationValue = null;
    }

    @Override
    public boolean _isElaborated() {
        return this.elaborated;
    }

    protected <X> JsonOverlay<X> _createScalar(String name, String path, OverlayFactory<X> factory) {
        return this._addChild(name, path, factory);
    }

    protected <X> ListOverlay<X> _createList(String name, String path, OverlayFactory<X> itemFactory) {
        return (ListOverlay)this._addChild(name, path, ListOverlay.getFactory(itemFactory));
    }

    protected <X> MapOverlay<X> _createMap(String name, String path, OverlayFactory<X> valueFactory, String keyPattern) {
        return (MapOverlay)this._addChild(name, path, MapOverlay.getFactory(valueFactory, keyPattern));
    }

    private <X> JsonOverlay<X> _addChild(String name, String path, OverlayFactory<X> factory) {
        JsonPointer pointer = JsonPointer.compile((String)(path.isEmpty() ? "" : "/" + path));
        JsonNode childJson = this.json.at(pointer);
        JsonOverlay<X> child = factory.create(childJson, (JsonOverlay<?>)this, this.refMgr);
        child._setPathInParent(path);
        PropertyLocator locator = new PropertyLocator(name, path, this.json);
        this.childOrder.add(locator);
        this.children.put(name, child);
        return child;
    }

    @Override
    protected JsonOverlay<?> _findInternal(JsonPointer path) {
        for (JsonOverlay<?> child : this.children.values()) {
            JsonOverlay<?> found;
            if (!this.matchesPath(child, path) || (found = child._find(this.tailPath(child, path))) == null) continue;
            return found;
        }
        return null;
    }

    private boolean matchesPath(JsonOverlay<?> child, JsonPointer path) {
        JsonPointer childPath = this.getPointer(child);
        while (!childPath.matches()) {
            if (!childPath.matchesProperty(path.getMatchingProperty())) {
                return false;
            }
            path = path.tail();
            childPath = childPath.tail();
        }
        return true;
    }

    private JsonPointer tailPath(JsonOverlay<?> child, JsonPointer path) {
        JsonPointer childPath = this.getPointer(child);
        while (!childPath.matches()) {
            path = path.tail();
            childPath = childPath.tail();
        }
        return path;
    }

    private JsonPointer getPointer(JsonOverlay<?> child) {
        String path = child._getPathInParent();
        return JsonPointer.compile((String)(path == null || path.isEmpty() ? "" : "/" + path));
    }

    @Override
    public V _fromJson(JsonNode json) {
        PropertiesOverlay result = this;
        return (V)result;
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        MissingNode obj = PropertiesOverlay._jsonMissing();
        for (PropertyLocator child : this.childOrder) {
            JsonNode childJson = this.children.get(child.getName())._toJson(options.minus(SerializationOptions.Option.KEEP_ONE_EMPTY));
            if (childJson.isMissingNode()) continue;
            obj = this._injectChild((JsonNode)obj, childJson, child.getPointer());
        }
        JsonNode result = this._fixJson((JsonNode)obj);
        return result.size() > 0 || options.isKeepThisEmpty() ? result : PropertiesOverlay._jsonMissing();
    }

    private JsonNode _injectChild(JsonNode node, JsonNode child, JsonPointer pointer) {
        if (pointer.matches()) {
            if (node.isMissingNode()) {
                return child;
            }
            if (node.isObject() && child.isObject()) {
                ((ObjectNode)node).setAll((ObjectNode)child);
                return node;
            }
            throw new IllegalArgumentException();
        }
        if (node.isObject() || node.isMissingNode()) {
            String name = pointer.getMatchingProperty();
            JsonNode childNode = this._injectChild(node.path(name), child, pointer.tail());
            if (!childNode.isMissingNode()) {
                node = node.isObject() ? node : PropertiesOverlay._jsonObject();
                ((ObjectNode)node).set(name, childNode);
            }
            return node;
        }
        throw new IllegalArgumentException();
    }

    protected JsonNode _fixJson(JsonNode json) {
        return json;
    }

    @Override
    public boolean equals(Object other) {
        return this.equals(other, false);
    }

    public boolean equals(Object other, boolean sameOrder) {
        if (other != null && this.getClass() == other.getClass()) {
            PropertiesOverlay otherPO = (PropertiesOverlay)other;
            if (this.elaborated != otherPO.elaborated) {
                return false;
            }
            if (this.children != null ? !this.children.equals(otherPO.children) : otherPO.children != null) {
                return false;
            }
            if (sameOrder) {
                return this.childOrder != null ? this.childOrder.equals(otherPO.childOrder) : otherPO.childOrder == null;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.children != null ? this.children.hashCode() : 0);
        hash = 31 * hash + (this.childOrder != null ? this.childOrder.hashCode() : 0);
        return hash;
    }

    protected static class PropertyLocator
    implements Comparable<PropertyLocator> {
        private final String name;
        private final JsonPointer pointer;
        private final List<Integer> vector;

        public PropertyLocator(String name, String path, JsonNode json) {
            this.name = name;
            this.pointer = JsonPointer.compile((String)(path.isEmpty() ? "" : "/" + path));
            this.vector = this.computeVector(this.pointer, json);
        }

        public String getName() {
            return this.name;
        }

        public JsonPointer getPointer() {
            return this.pointer;
        }

        private List<Integer> computeVector(JsonPointer pointer, JsonNode json) {
            JsonNode currentJson = json;
            ArrayList<Integer> result = new ArrayList<Integer>();
            while (currentJson instanceof ObjectNode && !pointer.matches()) {
                String key = pointer.getMatchingProperty();
                boolean found = false;
                int i = 0;
                Iterator iter = currentJson.fieldNames();
                while (iter.hasNext()) {
                    if (key.equals(iter.next())) {
                        found = true;
                        result.add(i);
                        currentJson = currentJson.get(key);
                        pointer = pointer.tail();
                        break;
                    }
                    ++i;
                }
                if (found) continue;
                return null;
            }
            return result.isEmpty() ? null : result;
        }

        @Override
        public int compareTo(PropertyLocator other) {
            if (this.vector == null) {
                return other.vector == null ? this.name.compareTo(other.name) : 1;
            }
            if (other.vector == null) {
                return -1;
            }
            int cmp = 0;
            for (int i = 0; cmp == 0 && i < this.vector.size() && i < other.vector.size(); ++i) {
                cmp = this.vector.get(i) - other.vector.get(i);
            }
            return cmp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.pointer == null ? 0 : this.pointer.hashCode());
            result = 31 * result + (this.vector == null ? 0 : this.vector.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyLocator other = (PropertyLocator)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.pointer == null ? other.pointer != null : !this.pointer.equals((Object)other.pointer)) {
                return false;
            }
            return !(this.vector == null ? other.vector != null : !this.vector.equals(other.vector));
        }

        public String toString() {
            return String.format("Loc[%s]=%s", this.name, this.vector);
        }
    }
}

