/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ItemsValidator.class);
    private static final String PROPERTY_ADDITIONAL_ITEMS = "additionalItems";
    private JsonSchema schema;
    private List<JsonSchema> tupleSchema;
    private boolean additionalItems = true;
    private JsonSchema additionalSchema;

    public ItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ITEMS);
        if (schemaNode.isObject()) {
            this.schema = new JsonSchema(mapper, this.getValidatorType().getValue(), schemaNode, parentSchema);
        } else {
            this.tupleSchema = new ArrayList<JsonSchema>();
            for (JsonNode s : schemaNode) {
                this.tupleSchema.add(new JsonSchema(mapper, this.getValidatorType().getValue(), s, parentSchema));
            }
            JsonNode addItemNode = this.getParentSchema().getSchemaNode().get(PROPERTY_ADDITIONAL_ITEMS);
            if (addItemNode != null) {
                if (addItemNode.isBoolean()) {
                    this.additionalItems = addItemNode.asBoolean();
                } else if (addItemNode.isObject()) {
                    this.additionalSchema = new JsonSchema(mapper, addItemNode);
                }
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        if (!node.isArray()) {
            return errors;
        }
        int i = 0;
        for (JsonNode n : node) {
            if (this.schema != null) {
                errors.addAll(this.schema.validate(n, rootNode, at + "[" + i + "]"));
            }
            if (this.tupleSchema != null) {
                if (i < this.tupleSchema.size()) {
                    errors.addAll(this.tupleSchema.get(i).validate(n, rootNode, at + "[" + i + "]"));
                } else if (this.additionalSchema != null) {
                    errors.addAll(this.additionalSchema.validate(n, rootNode, at + "[" + i + "]"));
                } else if (!this.additionalItems) {
                    errors.add(this.buildValidationMessage(at, "" + i));
                }
            }
            ++i;
        }
        return errors;
    }
}

