/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaximumValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MaximumValidator.class);
    private static final String PROPERTY_EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private double maximum;
    private boolean excludeEqual = false;

    public MaximumValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAXIMUM, validationContext);
        if (!schemaNode.isNumber()) {
            throw new JsonSchemaException("maximum value is not a number");
        }
        this.maximum = schemaNode.doubleValue();
        JsonNode exclusiveMaximumNode = this.getParentSchema().getSchemaNode().get(PROPERTY_EXCLUSIVE_MAXIMUM);
        if (exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean()) {
            this.excludeEqual = exclusiveMaximumNode.booleanValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (!node.isNumber()) {
            return Collections.emptySet();
        }
        String fieldType = this.getNodeFieldType();
        double value = node.doubleValue();
        if (this.greaterThan(value, this.maximum) || this.excludeEqual && this.equals(value, this.maximum)) {
            if (JsonType.INTEGER.toString().equals(fieldType)) {
                return Collections.singleton(this.buildValidationMessage(at, "" + (int)this.maximum));
            }
            return Collections.singleton(this.buildValidationMessage(at, "" + this.maximum));
        }
        return Collections.emptySet();
    }
}

