/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(IfValidator.class);
    private static final ArrayList<String> KEYWORDS = new ArrayList<String>(Arrays.asList("if", "then", "else"));
    private JsonSchema ifSchema;
    private JsonSchema thenSchema;
    private JsonSchema elseSchema;

    public IfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.IF_THEN_ELSE, validationContext);
        for (String keyword : KEYWORDS) {
            JsonNode node = schemaNode.get(keyword);
            if (keyword.equals("if")) {
                this.ifSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                this.thenSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            this.elseSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Set<ValidationMessage> ifErrors = this.ifSchema.validate(node, rootNode, at);
        if (ifErrors.isEmpty() && this.thenSchema != null) {
            errors.addAll(this.thenSchema.validate(node, rootNode, at));
        } else if (this.thenSchema != null && this.elseSchema != null) {
            errors.addAll(this.elseSchema.validate(node, rootNode, at));
        }
        return Collections.unmodifiableSet(errors);
    }
}

