/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(EnumValidator.class);
    private final Set<JsonNode> nodes;
    private final String error;

    public EnumValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ENUM, validationContext);
        if (schemaNode != null && schemaNode.isArray()) {
            this.nodes = new HashSet<JsonNode>();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            String separator = "";
            for (JsonNode n : schemaNode) {
                this.nodes.add(n);
                sb.append(separator);
                sb.append(n.asText());
                separator = ", ";
            }
            sb.append(']');
            this.error = sb.toString();
        } else {
            this.nodes = Collections.emptySet();
            this.error = "[none]";
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!(this.nodes.contains(node) || this.config.isTypeLoose() && this.isTypeLooseContainsInEnum(node))) {
            errors.add(this.buildValidationMessage(at, this.error));
        }
        return Collections.unmodifiableSet(errors);
    }

    private boolean isTypeLooseContainsInEnum(JsonNode node) {
        if (TypeFactory.getValueNodeType(node) == JsonType.STRING) {
            String nodeText = node.textValue();
            for (JsonNode n : this.nodes) {
                String value = n.asText();
                if (value == null || !value.equals(nodeText)) continue;
                return true;
            }
        }
        return false;
    }
}

