/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ThreadInfo;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorTypeCode;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonSchema
extends BaseJsonValidator {
    private static final Pattern intPattern = Pattern.compile("^[0-9]+$");
    protected Map<String, JsonValidator> validators;
    private final String idKeyword;
    private final ValidationContext validationContext;
    private final URI currentUri;
    private JsonValidator requiredValidator = null;

    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode) {
        this(validationContext, "#", baseUri, schemaNode, null);
    }

    public JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent) {
        this(validationContext, schemaPath, currentUri, schemaNode, parent, false);
    }

    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode, boolean suppressSubSchemaRetrieval) {
        this(validationContext, "#", baseUri, schemaNode, null, suppressSubSchemaRetrieval);
    }

    private JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(schemaPath, schemaNode, parent, null, suppressSubSchemaRetrieval, validationContext.getConfig() != null && validationContext.getConfig().isFailFast());
        this.validationContext = validationContext;
        this.config = validationContext.getConfig();
        this.idKeyword = validationContext.getMetaSchema().getIdKeyword();
        this.currentUri = this.combineCurrentUriWithIds(currentUri, schemaNode);
    }

    JsonSchema initialize() {
        this.validators = Collections.unmodifiableMap(this.read(this.getSchemaNode()));
        return this;
    }

    private URI combineCurrentUriWithIds(URI currentUri, JsonNode schemaNode) {
        String id = this.validationContext.resolveSchemaId(schemaNode);
        if (id == null) {
            return currentUri;
        }
        if (this.isUriFragmentWithNoContext(currentUri, id)) {
            return null;
        }
        try {
            return this.validationContext.getURIFactory().create(currentUri, id);
        }
        catch (IllegalArgumentException e) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.ID.getValue(), (ErrorMessageType)ValidatorTypeCode.ID, id, currentUri.toString()));
        }
    }

    private boolean isUriFragmentWithNoContext(URI currentUri, String id) {
        return id.startsWith("#") && currentUri == null;
    }

    public URI getCurrentUri() {
        return this.currentUri;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findAncestor();
        JsonNode node = schema.getSchemaNode();
        if (ref.startsWith("#/")) {
            String[] keys;
            for (String key : keys = ref.substring(2).split("/")) {
                try {
                    key = URLDecoder.decode(key, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                Matcher matcher = intPattern.matcher(key);
                node = matcher.matches() ? node.get(Integer.parseInt(key)) : node.get(key);
                if (node == null) {
                    node = this.handleNullNode(ref, schema);
                }
                if (node != null) {
                    continue;
                }
                break;
            }
        } else if (ref.startsWith("#") && ref.length() > 1 && (node = this.getNodeById(ref, node)) == null) {
            node = this.handleNullNode(ref, schema);
        }
        return node;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, JsonSchema schema) {
        JsonSchema subSchema = schema.fetchSubSchemaNode(this.validationContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private JsonNode getNodeById(String ref, JsonNode node) {
        if (this.nodeContainsRef(ref, node)) {
            return node;
        }
        Iterator children = node.elements();
        while (children.hasNext()) {
            JsonNode refNode = this.getNodeById(ref, (JsonNode)children.next());
            if (refNode == null) continue;
            return refNode;
        }
        return null;
    }

    private boolean nodeContainsRef(String ref, JsonNode node) {
        JsonNode id = node.get(this.idKeyword);
        if (id != null) {
            return ref.equals(id.asText());
        }
        return false;
    }

    private Map<String, JsonValidator> read(JsonNode schemaNode) {
        HashMap<String, JsonValidator> validators = new HashMap<String, JsonValidator>();
        if (schemaNode.isBoolean()) {
            if (schemaNode.booleanValue()) {
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "true", schemaNode, this);
                validators.put(this.getSchemaPath() + "/true", validator);
            } else {
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "false", schemaNode, this);
                validators.put(this.getSchemaPath() + "/false", validator);
            }
        } else {
            Iterator pnames = schemaNode.fieldNames();
            while (pnames.hasNext()) {
                JsonNode nodeToUse;
                String pname = (String)pnames.next();
                JsonNode jsonNode = nodeToUse = pname.equals("if") ? schemaNode : schemaNode.get(pname);
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), pname, nodeToUse, this);
                if (validator == null) continue;
                validators.put(this.getSchemaPath() + "/" + pname, validator);
                if (!pname.equals("required")) continue;
                this.requiredValidator = validator;
            }
        }
        return validators;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode jsonNode, JsonNode rootNode, String at) {
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (JsonValidator v : this.validators.values()) {
            errors.addAll(v.validate(jsonNode, rootNode, at));
        }
        return errors;
    }

    public ValidationResult validateAndCollect(JsonNode node) {
        return this.validateAndCollect(node, node, "$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValidationResult validateAndCollect(JsonNode jsonNode, JsonNode rootNode, String at) {
        try {
            ValidationResult validationResult;
            CollectorContext collectorContext = new CollectorContext();
            ThreadInfo.set("com.networknt.schema.CollectorKey", collectorContext);
            Set<ValidationMessage> errors = this.validate(jsonNode, rootNode, at);
            collectorContext.loadCollectors();
            ValidationResult validationResult2 = validationResult = new ValidationResult(errors, collectorContext);
            return validationResult2;
        }
        finally {
            ThreadInfo.remove("com.networknt.schema.CollectorKey");
        }
    }

    public String toString() {
        return "\"" + this.getSchemaPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasRequiredValidator() {
        return this.requiredValidator != null;
    }

    public JsonValidator getRequiredValidator() {
        return this.requiredValidator;
    }

    public Map<String, JsonValidator> getValidators() {
        return this.validators;
    }
}

