/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class BaseJsonValidator
implements JsonValidator {
    protected String schemaPath;
    protected JsonNode schemaNode;
    protected JsonSchema parentSchema;
    private boolean suppressSubSchemaRetrieval;
    private ValidatorTypeCode validatorType;
    private ErrorMessageType errorMessageType;
    protected SchemaValidatorsConfig config;
    protected final boolean failFast;

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, ValidationContext validationContext) {
        this(schemaPath, schemaNode, parentSchema, validatorType, false, validationContext.getConfig() != null && validationContext.getConfig().isFailFast());
        this.config = validationContext.getConfig() == null ? new SchemaValidatorsConfig() : validationContext.getConfig();
    }

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, boolean suppressSubSchemaRetrieval, boolean failFast) {
        this.errorMessageType = validatorType;
        this.schemaPath = schemaPath;
        this.schemaNode = schemaNode;
        this.parentSchema = parentSchema;
        this.validatorType = validatorType;
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
        this.failFast = failFast;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    protected JsonSchema fetchSubSchemaNode(ValidationContext validationContext) {
        return this.suppressSubSchemaRetrieval ? null : BaseJsonValidator.obtainSubSchemaNode(this.schemaNode, validationContext);
    }

    private static JsonSchema obtainSubSchemaNode(JsonNode schemaNode, ValidationContext validationContext) {
        URI uri;
        JsonNode node = schemaNode.get("id");
        if (node == null) {
            return null;
        }
        if (node.equals((Object)schemaNode.get("$schema"))) {
            return null;
        }
        String text = node.textValue();
        if (text == null) {
            return null;
        }
        try {
            uri = validationContext.getURIFactory().create(node.textValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return validationContext.getJsonSchemaFactory().getSchema(uri, validationContext.getConfig());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, "$");
    }

    protected boolean equals(double n1, double n2) {
        return Math.abs(n1 - n2) < 1.0E-12;
    }

    protected boolean greaterThan(double n1, double n2) {
        return n1 - n2 > 1.0E-12;
    }

    protected boolean lessThan(double n1, double n2) {
        return n1 - n2 < -1.0E-12;
    }

    protected void parseErrorCode(String errorCodeKey) {
        String errorCodeText;
        JsonNode errorCodeNode = this.getParentSchema().getSchemaNode().get(errorCodeKey);
        if (errorCodeNode != null && errorCodeNode.isTextual() && StringUtils.isNotBlank((CharSequence)(errorCodeText = errorCodeNode.asText()))) {
            this.errorMessageType = CustomErrorMessageType.of(errorCodeText);
        }
    }

    protected ValidationMessage buildValidationMessage(String at, String ... arguments) {
        ValidationMessage message = ValidationMessage.of(this.getValidatorType().getValue(), this.errorMessageType, at, arguments);
        if (this.failFast && !this.isPartOfOneOfMultipleType()) {
            throw new JsonSchemaException(message);
        }
        return message;
    }

    protected void debug(Logger logger, JsonNode node, JsonNode rootNode, String at) {
        if (logger.isDebugEnabled()) {
            logger.debug("validate( " + node + ", " + rootNode + ", " + at + ")");
        }
    }

    protected ValidatorTypeCode getValidatorType() {
        return this.validatorType;
    }

    protected String getNodeFieldType() {
        JsonNode typeField = this.getParentSchema().getSchemaNode().get("type");
        if (typeField != null) {
            return typeField.asText();
        }
        return null;
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        Set<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages = this.validate(node, rootNode, at);
        }
        return validationMessages;
    }

    protected boolean isPartOfOneOfMultipleType() {
        return this.parentSchema.schemaPath.equals(ValidatorTypeCode.ONE_OF.getValue());
    }
}

