/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.url.URLFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class BaseJsonValidator
implements JsonValidator {
    private String schemaPath;
    private JsonNode schemaNode;
    private JsonSchema parentSchema;
    private boolean suppressSubSchemaRetrieval;
    private ValidatorTypeCode validatorType;
    private ErrorMessageType errorMessageType;
    protected SchemaValidatorsConfig config;

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, ValidationContext validationContext) {
        this(schemaPath, schemaNode, parentSchema, validatorType, false);
        this.config = validationContext.getConfig() == null ? new SchemaValidatorsConfig() : validationContext.getConfig();
    }

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, boolean suppressSubSchemaRetrieval) {
        this.errorMessageType = validatorType;
        this.schemaPath = schemaPath;
        this.schemaNode = schemaNode;
        this.parentSchema = parentSchema;
        this.validatorType = validatorType;
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
    }

    protected String getSchemaPath() {
        return this.schemaPath;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    protected JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    protected JsonSchema fetchSubSchemaNode(ValidationContext validationContext) {
        return this.suppressSubSchemaRetrieval ? null : BaseJsonValidator.obtainSubSchemaNode(this.schemaNode, validationContext);
    }

    private static JsonSchema obtainSubSchemaNode(JsonNode schemaNode, ValidationContext validationContext) {
        JsonNode node = schemaNode.get("id");
        if (node == null) {
            return null;
        }
        if (node.equals((Object)schemaNode.get("$schema"))) {
            return null;
        }
        try {
            String text = node.textValue();
            if (text == null) {
                return null;
            }
            URL url = URLFactory.toURL(node.textValue());
            return validationContext.getJsonSchemaFactory().getSchema(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, "$");
    }

    protected boolean equals(double n1, double n2) {
        return Math.abs(n1 - n2) < 1.0E-12;
    }

    protected boolean greaterThan(double n1, double n2) {
        return n1 - n2 > 1.0E-12;
    }

    protected boolean lessThan(double n1, double n2) {
        return n1 - n2 < -1.0E-12;
    }

    protected void parseErrorCode(String errorCodeKey) {
        String errorCodeText;
        JsonNode errorCodeNode = this.getParentSchema().getSchemaNode().get(errorCodeKey);
        if (errorCodeNode != null && errorCodeNode.isTextual() && StringUtils.isNotBlank((CharSequence)(errorCodeText = errorCodeNode.asText()))) {
            this.errorMessageType = CustomErrorMessageType.of(errorCodeText);
        }
    }

    protected ValidationMessage buildValidationMessage(String at, String ... arguments) {
        return ValidationMessage.of(this.getValidatorType().getValue(), this.errorMessageType, at, arguments);
    }

    protected void debug(Logger logger, JsonNode node, JsonNode rootNode, String at) {
        if (logger.isDebugEnabled()) {
            logger.debug("validate( " + node + ", " + rootNode + ", " + at + ")");
        }
    }

    protected ValidatorTypeCode getValidatorType() {
        return this.validatorType;
    }

    protected String getNodeFieldType() {
        JsonNode typeField = this.getParentSchema().getSchemaNode().get("type");
        if (typeField != null) {
            return typeField.asText();
        }
        return null;
    }
}

