/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnEvaluatedPropertiesValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnEvaluatedPropertiesValidator.class);
    private static final String UNEVALUATED_PROPERTIES = "com.networknt.schema.UnEvaluatedPropertiesValidator.UnevaluatedProperties";
    private final JsonSchema schema;

    public UnEvaluatedPropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_PROPERTIES, validationContext);
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedProperties' MUST be a valid JSON Schema.");
        }
        this.schema = new JsonSchema(validationContext, schemaPath, parentSchema.getCurrentUri(), schemaNode, parentSchema);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        Set<String> allPaths = this.allPaths(node, at);
        Set<String> unevaluatedPaths = this.unevaluatedPaths(allPaths);
        LinkedHashSet failingPaths = new LinkedHashSet();
        unevaluatedPaths.forEach(path -> {
            String pointer = this.getPathType().convertToJsonPointer((String)path);
            JsonNode property = rootNode.at(pointer);
            if (!this.schema.validate(property, rootNode, (String)path).isEmpty()) {
                failingPaths.add(path);
            }
        });
        if (!failingPaths.isEmpty()) {
            CollectorContext.getInstance().add(UNEVALUATED_PROPERTIES, unevaluatedPaths);
            return Collections.singleton(this.buildValidationMessage(String.join((CharSequence)", ", failingPaths), new String[0]));
        }
        CollectorContext.getInstance().getEvaluatedProperties().addAll(allPaths);
        return Collections.emptySet();
    }

    private Set<String> unevaluatedPaths(Set<String> allPaths) {
        LinkedHashSet<String> unevaluatedProperties = new LinkedHashSet<String>(allPaths);
        unevaluatedProperties.removeAll(CollectorContext.getInstance().getEvaluatedProperties());
        return unevaluatedProperties;
    }

    private Set<String> allPaths(JsonNode node, String at) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        this.processAllPaths(node, at, results);
        return results;
    }

    private void processAllPaths(JsonNode node, String at, Set<String> paths) {
        Iterator nodesIterator = node.fieldNames();
        while (nodesIterator.hasNext()) {
            String fieldName = (String)nodesIterator.next();
            String path = this.atPath(at, fieldName);
            paths.add(path);
            JsonNode jsonNode = node.get(fieldName);
            if (!jsonNode.isObject()) continue;
            this.processAllPaths(jsonNode, path, paths);
        }
    }
}

