/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(IfValidator.class);
    private static final ArrayList<String> KEYWORDS = new ArrayList<String>(Arrays.asList("if", "then", "else"));
    private final JsonSchema ifSchema;
    private final JsonSchema thenSchema;
    private final JsonSchema elseSchema;

    public IfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.IF_THEN_ELSE, validationContext);
        JsonSchema foundIfSchema = null;
        JsonSchema foundThenSchema = null;
        JsonSchema foundElseSchema = null;
        for (String keyword : KEYWORDS) {
            JsonNode node = schemaNode.get(keyword);
            String schemaPathOfSchema = parentSchema.schemaPath + "/" + keyword;
            if (keyword.equals("if")) {
                foundIfSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                foundThenSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            foundElseSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
        }
        this.ifSchema = foundIfSchema;
        this.thenSchema = foundThenSchema;
        this.elseSchema = foundElseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = CollectorContext.getInstance();
        Collection<String> backupEvaluatedProperties = collectorContext.getEvaluatedProperties();
        Collection<Object> ifEvaluatedProperties = Collections.emptyList();
        Collection<Object> thenEvaluatedProperties = Collections.emptyList();
        Collection<Object> elseEvaluatedProperties = Collections.emptyList();
        collectorContext.resetEvaluatedProperties();
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        boolean ifConditionPassed = false;
        try {
            try {
                ifConditionPassed = this.ifSchema.validate(node, rootNode, at).isEmpty();
            }
            catch (JsonSchemaException ex) {
                ifConditionPassed = false;
            }
            ifEvaluatedProperties = collectorContext.getEvaluatedProperties();
            if (ifConditionPassed && this.thenSchema != null) {
                collectorContext.resetEvaluatedProperties();
                errors.addAll(this.thenSchema.validate(node, rootNode, at));
                thenEvaluatedProperties = collectorContext.getEvaluatedProperties();
            } else if (!ifConditionPassed && this.elseSchema != null) {
                collectorContext.resetEvaluatedProperties();
                errors.addAll(this.elseSchema.validate(node, rootNode, at));
                elseEvaluatedProperties = collectorContext.getEvaluatedProperties();
            }
        }
        finally {
            collectorContext.setEvaluatedProperties(backupEvaluatedProperties);
            if (errors.isEmpty()) {
                if (ifConditionPassed) {
                    collectorContext.getEvaluatedProperties().addAll(ifEvaluatedProperties);
                }
                collectorContext.getEvaluatedProperties().addAll(thenEvaluatedProperties);
                collectorContext.getEvaluatedProperties().addAll(elseEvaluatedProperties);
            }
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.ifSchema) {
            this.ifSchema.initializeValidators();
        }
        if (null != this.thenSchema) {
            this.thenSchema.initializeValidators();
        }
        if (null != this.elseSchema) {
            this.elseSchema.initializeValidators();
        }
    }
}

