/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.networknt.schema.AbstractFormat;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;

public class TimeFormat
extends AbstractFormat {
    private static final long MAX_OFFSET_MIN = 1439L;
    private static final long MIN_OFFSET_MIN = -1439L;
    private static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:MM", "Z").parseLenient().toFormatter();

    public TimeFormat() {
        super("time", "^(?:(?:[01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])(?:\\.\\d+)?(?:Z|[+-](?:(?:0[0-9]|2[0-3]):[0-5][0-9]))$");
    }

    @Override
    public boolean matches(String value) {
        try {
            if (null == value) {
                return true;
            }
            int pos = value.indexOf(90);
            if (-1 != pos && pos != value.length() - 1) {
                return false;
            }
            TemporalAccessor accessor = formatter.parseUnresolved(value, new ParsePosition(0));
            if (null == accessor) {
                return false;
            }
            long offset = accessor.getLong(ChronoField.OFFSET_SECONDS) / 60L;
            if (1439L < offset || -1439L > offset) {
                return false;
            }
            long hr = accessor.getLong(ChronoField.HOUR_OF_DAY) - offset / 60L;
            long min = accessor.getLong(ChronoField.MINUTE_OF_HOUR) - offset % 60L;
            long sec = accessor.getLong(ChronoField.SECOND_OF_MINUTE);
            if (min < 0L) {
                --hr;
                min += 60L;
            }
            if (hr < 0L) {
                hr += 24L;
            }
            return sec <= 59L && min <= 59L && hr <= 23L || sec == 60L && min == 59L && hr == 23L;
        }
        catch (DateTimeException e) {
            return false;
        }
    }
}

