/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.CollectorContext;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ExecutionConfig;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.ValidatorState;
import java.util.Stack;

public class ExecutionContext {
    private ExecutionConfig executionConfig;
    private CollectorContext collectorContext;
    private ValidatorState validatorState = null;
    private Stack<DiscriminatorContext> discriminatorContexts = new Stack();

    public ExecutionContext() {
        this(new CollectorContext());
    }

    public ExecutionContext(CollectorContext collectorContext) {
        this(new ExecutionConfig(), collectorContext);
    }

    public ExecutionContext(ExecutionConfig executionConfig) {
        this(executionConfig, new CollectorContext());
    }

    public ExecutionContext(ExecutionConfig executionConfig, CollectorContext collectorContext) {
        this.collectorContext = collectorContext;
        this.executionConfig = executionConfig;
    }

    public CollectorContext getCollectorContext() {
        return this.collectorContext;
    }

    public void setCollectorContext(CollectorContext collectorContext) {
        this.collectorContext = collectorContext;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
    }

    public ValidatorState getValidatorState() {
        return this.validatorState;
    }

    public void setValidatorState(ValidatorState validatorState) {
        this.validatorState = validatorState;
    }

    public DiscriminatorContext getCurrentDiscriminatorContext() {
        if (!this.discriminatorContexts.empty()) {
            return this.discriminatorContexts.peek();
        }
        return null;
    }

    public void enterDiscriminatorContext(DiscriminatorContext ctx, JsonNodePath instanceLocation) {
        this.discriminatorContexts.push(ctx);
    }

    public void leaveDiscriminatorContextImmediately(JsonNodePath instanceLocation) {
        this.discriminatorContexts.pop();
    }
}

